package net.sf.itcb.common.portlet.vaadin.interceptor.request.impl;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

import net.sf.itcb.common.portlet.portal.PortalAdapter;
import net.sf.itcb.common.portlet.portal.PortalAdapterProvider;
import net.sf.itcb.common.portlet.vaadin.ItcbVaadinApplication;
import net.sf.itcb.common.portlet.vaadin.interceptor.request.ItcbRequestInterceptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.UserDetails;

/**
 * This filter retrieves the specific PortalAdapter (Liferay...) then set the SpringSecurityContextHolder with user, password and roles from the portal request context
 * It fills the user in application at init
 * @since 0.5.0
 * @author Pierre Le Roux
 */
public class InitSpringSecurityInterceptor implements ItcbRequestInterceptor {

	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	protected net.sf.itcb.common.portlet.portal.PortalAdapterProvider portalAdapterProvider;

	public void setPortalAdapterProvider(PortalAdapterProvider portalAdapterProvider) {
		this.portalAdapterProvider = portalAdapterProvider;
	}

	@Override
	public void handleRequestStart(ItcbVaadinApplication application,
			HttpServletRequest servletRequest) {
		// TODO Define what to do in servlet mode 
		
	}

	@Override
	public void handleRequestStart(ItcbVaadinApplication application,
			PortletRequest portletRequest) {
		if(portalAdapterProvider != null) {
			PortalAdapter portalAdapter = portalAdapterProvider.getPortalAdapter(portletRequest);
			UserDetails user = portalAdapter.getUser(portletRequest);
			if(user != null) {
				UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(user.getUsername(),user.getPassword(), user.getAuthorities());
				application.setUser(authentication);
			}
		}
		
	}

	@Override
	public void handleRequestEnd(ItcbVaadinApplication application,
			HttpServletRequest servletRequest) {
		// Nothing
	}

	@Override
	public void handleRequestEnd(ItcbVaadinApplication application,
			PortletRequest portletRequest) {
		// Nothing
	}

}
