package net.sf.itcb.common.portlet.vaadin.interceptor.page.impl;

import net.sf.itcb.common.portlet.vaadin.component.ItcbComponent;
import net.sf.itcb.common.portlet.vaadin.component.ItcbPage;
import net.sf.itcb.common.portlet.vaadin.interceptor.page.ChangePageInterceptor;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor.ReloadOrder;

/**
 * This interceptor adds google analytics script when you browse your application.<br/>
 * Script is added in handleAfterChangePage method. It means that google analytics script is only executed if the component to display is an {@link ItcbPage} and had been really loaded<br/>
 * If the page is called many times in the same application, google analytics call is done only once.
 * @author Pierre Le Roux
 * @since 0.5.0
 */
public class GoogleAnalyticsChangePageInterceptor implements
		ChangePageInterceptor {
	
	String accountId;
	
	String prefix;
	
	/**
	 * Your google analytics account id
	 * @param accountId
	 */
	public void setGoogleAnalyticsSiteId(String accountId) {
		this.accountId = accountId;
	}
	
	/**
	 * Prefix you want to add before your page reference : Must begin with a "/" and end with a "/"
	 * @param prefix
	 */
	public void setPrefix(String prefix) {
		if(!prefix.startsWith("/")) {
			prefix="/"+prefix;
		}
		if(!prefix.endsWith("/")) {
			prefix=prefix+"/";
		}
		this.prefix = prefix;
	}

	@Override
	public Object handleBeforeChangePage(String pageRef, ItcbComponent itcbComponent, ReloadOrder reloadOrder) {
		return null; // Nothing to store
	}

	@Override
	public void handleAfterChangePage(String pageRef, ItcbComponent itcbComponent, ReloadOrder reloadOrder,
			ExecutedAction executedAction, Object requestContextVar) {
		 
			 if(itcbComponent instanceof ItcbPage && executedAction.equals(ExecutedAction.FULL_LOAD)) {
				 ItcbPage page = (ItcbPage) itcbComponent;
		 
				 // Google Analytics
				 // Track the page view
				 StringBuffer sb = new StringBuffer(50);
				 sb.append("_gaq.push(['_setAccount', '")
				 	.append(accountId)
				 	.append("'],")
				 	.append("['_trackPageview', '")
				 	.append(prefix)
				 	.append(pageRef)
				 	.append(".html']);");
				 sb.append("_gaq.push(['_trackPageLoadTime']);");
				 page.getApplication().getMainWindow().executeJavaScript(sb.toString());
			 }
		
	}

	@Override
	public void handleChangePageException(String pageRef, ItcbComponent itcbComponent,
			ReloadOrder reloadOrder, ExecutedAction executedAction,
			Object requestContextVar, Throwable throwable) {
		// Nothing
	}




}
