package net.sf.itcb.common.portlet.vaadin.component.impl;


import net.sf.itcb.common.portlet.vaadin.component.ItcbPage;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.ui.CustomLayout;

/**
 * Each page has to extend this class
 * 
 * @author Pierre Le Roux
 *
 */
public abstract class AbstractItcbCustomPage extends CustomLayout implements ItcbPage {

	private static final long serialVersionUID = 1L;

	private PageMappingProcessor pageMappingProcessor;
	
	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	public AbstractItcbCustomPage() {
		super("");
		// To define the custom page, it can be done in defineContentDelegate 
		//or by injecting the content with Spring using the property templateContents
	}
	
	public PageMappingProcessor getPageMappingProcessor() {
		return pageMappingProcessor;
	}
	
	@Override
	public void init() throws Exception {
		if(log.isDebugEnabled()) {
			log.debug("Initializing {}", getClass());
		}
		defineContentDelegate();
	}
	
	protected abstract void defineContentDelegate() throws Exception;

	public void setPageMappingProcessor(
			PageMappingProcessor pageMappingProcessor) {
		this.pageMappingProcessor = pageMappingProcessor;
	}
	   	
}

