package net.sf.itcb.common.portlet.vaadin.component;

import com.vaadin.ui.ComponentContainer;

import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor.ReloadOrder;



/**
 * Each page has to extend this class
 * 
 * @author Pierre Le Roux
 *
 */
public interface ItcbPage extends ComponentContainer, ItcbComponent {
		
	/**
	 * This interface has to be implemented by any page which has to be updated on each displayPage if delegateContent is not called once again<br/>
	 * We can meet this situation if {@link PageMappingProcessor#displayPage(String, net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor.ReloadOrder)} 
	 * function is called with {@link ReloadOrder#IF_MODIFIED} or {@link ReloadOrder#FALSE} <br/>
	 * It is usefull to keep fields values as typed by user but update a part of screen using model or session updated information.<br/>
	 * The update function has to be implemented by subclasses in order to update a part of screen.
	 * @author Pierre Le Roux
	 *
	 */
	public interface Updatable {
		public void update();
	}
	
	/**
	 * This interface has to be implemented by any page which can be preloaded with default values
	 * Developers have to code default values logic in an overrided {@link FieldsValuePreLoadable#fillFieldsWithValues()} method
	 * @author Pierre Le Roux
	 */
	public interface FieldsValuePreLoadable {
		/**
		 * Method that has to be overrided in order to fill fields when the page is loaded
		 */
		public void fillFieldsWithValues();
	}
		   	
}

