package net.sf.itcb.common.portlet.vaadin;

import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;

import net.sf.itcb.common.portlet.exceptions.PortletItcbException;
import net.sf.itcb.common.portlet.exceptions.PortletItcbExceptionMappingErrors;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.terminal.Terminal;
import com.vaadin.terminal.gwt.server.ChangeVariablesErrorEvent;
import com.vaadin.ui.Window;

/**
 * An extension of Window with a pageMappingProcessor embedded.
 * This window can be used to add a subwindow with pages mecanism
 * 
 * This window doesn't make uri change in order to keep uri changes only in main window
 * @author Pierre Le Roux
 */
public class PageMappingProcessorWindow extends Window {
	
	private static final long serialVersionUID = 1L;
	
	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	/**
	 * The current {@link PageMappingProcessor} used by window
	 */
	protected PageMappingProcessor windowPageMappingProcessor;
	
	public void setPageMappingProcessor(PageMappingProcessor pageMappingProcessor) {
		this.windowPageMappingProcessor=pageMappingProcessor;
	}
	
	public PageMappingProcessor getPageMappingProcessor() {
		return windowPageMappingProcessor;
	}
		
	/**
	 * Common method called on init request.<br/>
	 * Spring configuration is loaded such as the PageMappingProcessor associated to the {@link PortletMode} (in portal context)
	 * or to the <code>itcbmode</code> request parameter (in servlet context)
	 * @param servletRequest the servlet request when application is launched as web application
	 * @param portletRequest the portlet request when application is launched as portlet
	 */
	public void initWindow(PageMappingProcessor originalPageMappingProcessor) {

		windowPageMappingProcessor.setApplication(originalPageMappingProcessor.getApplication());

		windowPageMappingProcessor.setWindow(this);
		Object originalRequest = originalPageMappingProcessor.getRequest();
		if(originalRequest instanceof PortletRequest) {
			windowPageMappingProcessor.setInitRequest((PortletRequest)originalPageMappingProcessor.getRequest());
			windowPageMappingProcessor.setInitRequest(originalPageMappingProcessor.getPortalAdapter().getOriginalServletRequest());
		}
		else if(originalRequest instanceof ServletRequest) {
			windowPageMappingProcessor.setInitRequest((ServletRequest)originalPageMappingProcessor.getRequest());
		}
		try {
			windowPageMappingProcessor.displayDefaultPage();
		} 
		catch (Exception e) {
				PortletItcbException portletItcbException = new PortletItcbException(PortletItcbExceptionMappingErrors.COMMON_PORTLET_LOADING_PAGE, e.getMessage(), e);
				Terminal.ErrorEvent errorEvent = new ChangeVariablesErrorEvent(this, portletItcbException, null);
				windowPageMappingProcessor.handleError(errorEvent);
		}
		log.debug("End initItcb");
	}

	

		
		
	
	
}
