package net.sf.itcb.common.portlet.portal.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;

import net.sf.itcb.common.portlet.exceptions.PortletItcbException;
import net.sf.itcb.common.portlet.exceptions.PortletItcbExceptionMappingErrors;
import net.sf.itcb.common.portlet.portal.PortalAdapter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Role;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
/**
 * 
 * This class's aim is to transform a Liferay specific context in a common spring context.<br/>
 * In a first time, only user data are managed.<br/>
 * It's the only class using Liferay classes. When we use this class, it means that the framework saw that the porlet had been lauched in Liferay.<br/>
 * This class extends the standard {@link PortalAdapter}.<br/>
 * 
 * @author Pierre Le Roux
 *
 */
public class LiferayAdapter implements PortalAdapter<PortletRequest>, Serializable {

	private static final long serialVersionUID = 1L;
	
	protected final Logger log = LoggerFactory.getLogger(getClass());

	@Override
	public UserDetails getUser(PortletRequest request) {
		User userSpring =null;
		try {
			com.liferay.portal.model.User userLiferay = PortalUtil.getUser(request);
			if(userLiferay != null) {
				Collection<GrantedAuthority> grantedAutorithies = new ArrayList<GrantedAuthority>();
				
				List<Role> listRole = userLiferay.getRoles();
				for (Role role : listRole) {
					grantedAutorithies.add(new GrantedAuthorityImpl(role.getName()));
				}
				userSpring = new User(userLiferay.getLogin(), userLiferay.getPassword(), userLiferay.getActive(), !userLiferay.getLockout(), userLiferay.getAgreedToTermsOfUse(), !userLiferay.getLockout(), grantedAutorithies);
				
			}
		} catch (Exception e1) {
			// If an exception is thrown, no action.
			log.error("Unexpected error occurs : {}", e1.getMessage());
			if(log.isDebugEnabled()) {
				e1.printStackTrace();
			}
		}
		return userSpring;
	}

	@Override
	public HttpServletRequest getOriginalServletRequest(PortletRequest request) {
		HttpServletRequest servletRequest = PortalUtil.getHttpServletRequest(request);
		servletRequest = PortalUtil.getOriginalServletRequest(servletRequest);
		
		return servletRequest;
	}

	@Override
	public String getTheme(PortletRequest request) {
		ThemeDisplay td = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
		if(td != null) {
			return td.getThemeId();
		}
		return null;
	}

	@Override
	public String getImpersonatedUser(PortletRequest request) {
		return ParamUtil.getString(request, "doAsUserId");
	}

	@Override
	public final Map<String, String[]> getApplicationPreferences(PortletRequest request) {
		return request.getPreferences().getMap();	
	}

	@Override
	public void updateApplicationPreferences(PortletRequest request,
			Map<String, String []> orders) {
		PortletPreferences portletPreferences = request.getPreferences();
		try {
			for (Map.Entry<String, String[]> order : orders.entrySet()) {
				if(order.getValue() != null) {
	
						portletPreferences.setValues(order.getKey(), order.getValue());
	
				}
				else {
					portletPreferences.reset(order.getKey());
				}
			}
			portletPreferences.store();
		} catch (ReadOnlyException e) {
			throw new PortletItcbException(PortletItcbExceptionMappingErrors.UPDATE_PREFERENCES_ERROR, PortletItcbExceptionMappingErrors.UPDATE_PREFERENCES_ERROR.getMessage(), e); // TODO Internationalize this exception
		} catch (ValidatorException e) {
			throw new PortletItcbException(PortletItcbExceptionMappingErrors.UPDATE_PREFERENCES_ERROR, PortletItcbExceptionMappingErrors.UPDATE_PREFERENCES_ERROR.getMessage(), e); // TODO Internationalize this exception
		} catch (IOException e) {
			throw new PortletItcbException(PortletItcbExceptionMappingErrors.UPDATE_PREFERENCES_ERROR, PortletItcbExceptionMappingErrors.UPDATE_PREFERENCES_ERROR.getMessage(), e); // TODO Internationalize this exception
		}
	}

}
