package net.sf.itcb.common.portlet.portal;

import java.util.Map;

import javax.servlet.ServletRequest;

import org.springframework.security.core.userdetails.UserDetails;

/**
 * This interface declares all the methods needed to be implemented by a child class in order to transform specific portal or servlet container data (liferay, JBOSS...) in common data.
 *  
 * @author Pierre Le Roux
 */
public interface PortalAdapter<T> {
	
	/* Session scope */
	public UserDetails getUser(T request);
	
	public ServletRequest getOriginalServletRequest(T request);
	
	public String getTheme(T request);
	
	public String getImpersonatedUser(T request);
	
	
	/* Application scope */
	public Map<String, String[]> getApplicationPreferences(T request);
	
	public void updateApplicationPreferences(T request, Map<String, String[]> orders);
	
}
