package net.sf.itcb.common.portlet.filter;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

import net.sf.itcb.common.business.core.ItcbApplicationContextHolder;
import net.sf.itcb.common.portlet.portal.PortalAdapter;
import net.sf.itcb.common.portlet.portal.PortalAdapterProvider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

/**
 * This filter retrieves the specific PortalAdapter (Liferay...) then set the SpringSecurityContextHolder with user, password and roles from the portal request context 
 * @deprecated use {@link net.sf.itcb.common.portlet.vaadin.interceptor.impl.InitSpringSecurityInterceptor} and {@link net.sf.itcb.common.portlet.vaadin.interceptor.impl.RequestSpringSecurityInterceptor}in Spring context instead
 * @author Pierre Le Roux
 */
public class SpringSecurityFilter implements RenderFilter, ActionFilter, ResourceFilter, EventFilter {

	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	@Override
	public void init(FilterConfig filterConfig) throws PortletException {
		log.info("SpringSecurityFilter initialized");
	}

	@Override
	public void destroy() {
		log.info("SpringSecurityFilter destroyed");
	}
	
	protected net.sf.itcb.common.portlet.portal.PortalAdapterProvider portalAdapterProvider = null;

	@Override
	public void doFilter(RenderRequest request, RenderResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
	}

	@Override
	public void doFilter(EventRequest request, EventResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
		
	}

	@Override
	public void doFilter(ResourceRequest request, ResourceResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
	}

	@Override
	public void doFilter(ActionRequest request, ActionResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
	}
	
	private void doFilterDelegate(PortletRequest request,
			PortletResponse response, FilterChain chain) throws IOException,
			PortletException {
		if(portalAdapterProvider == null) {
			portalAdapterProvider= ItcbApplicationContextHolder.getContext().getBean("itcbPortalAdapterProvider", PortalAdapterProvider.class);
		}
			
		if(portalAdapterProvider != null) {
			PortalAdapter portalAdapter = portalAdapterProvider.getPortalAdapter(request);
			UserDetails user = portalAdapter.getUser(request);
			SecurityContext securityContext = SecurityContextHolder.getContext();
			if(user != null) {
				securityContext.setAuthentication(new UsernamePasswordAuthenticationToken(user.getUsername(),user.getPassword(), user.getAuthorities()));
			}
		}
	}

}
