package net.sf.itcb.common.portlet.vaadin.interceptor.request.impl;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

import net.sf.itcb.common.portlet.vaadin.ItcbVaadinApplication;
import net.sf.itcb.common.portlet.vaadin.interceptor.request.ItcbRequestInterceptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * This filter retrieves the specific PortalAdapter (Liferay...) then set the SpringSecurityContextHolder with user, password and roles from the portal request context
 * It fills the user in application 
 * 
 * @author Pierre Le Roux
 */
public class RequestSpringSecurityInterceptor implements ItcbRequestInterceptor {

	protected final Logger log = LoggerFactory.getLogger(getClass());

	@Override
	public void handleRequestStart(ItcbVaadinApplication application,
			HttpServletRequest servletRequest) {
		Object user = application.getUser();
		if(user != null && user instanceof Authentication) {
			SecurityContextHolder.getContext().setAuthentication((Authentication)user);
		}
	}

	@Override
	public void handleRequestStart(ItcbVaadinApplication application,
			PortletRequest portletRequest) {
		Object user = application.getUser();
		if(user != null && user instanceof Authentication) {
			SecurityContextHolder.getContext().setAuthentication((Authentication)user);
		}
	}

	@Override
	public void handleRequestEnd(ItcbVaadinApplication application,
			HttpServletRequest servletRequest) {
		SecurityContextHolder.clearContext();
	}

	@Override
	public void handleRequestEnd(ItcbVaadinApplication application,
			PortletRequest portletRequest) {
		SecurityContextHolder.clearContext();
	}

}
