package net.sf.itcb.common.portlet.vaadin.exception;

import com.vaadin.terminal.Terminal;

import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;

/**
 * This interface has to be implemented for each ExceptionHandler
 * @author Pierre Le Roux
 *
 */
public interface ExceptionHandler {
	
	/**
	 * Handle an exception using the pageMappingProcessor in parameter
	 * @param e the error including the exception
	 * @param pageMappingProcessor the pageMappingProcessor
	 */
	public abstract void handleError(Terminal.ErrorEvent error, PageMappingProcessor pageMappingProcessor);
}
