package net.sf.itcb.common.portlet.vaadin.config;

import java.util.List;
import java.util.Map;

import javax.portlet.PortletMode;

import org.springframework.beans.factory.annotation.Required;

import net.sf.itcb.common.portlet.portal.PortalAdapterProvider;
import net.sf.itcb.common.portlet.vaadin.ItcbVaadinApplication;
import net.sf.itcb.common.portlet.vaadin.interceptor.request.ItcbRequestInterceptor;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;

import com.vaadin.Application;

/**
 * Itcb Vaadin application configuration that should be injected by Spring bean.<br/>
 * It allows to declare all pageMappingProcessors used by the application depending on the mode, 
 * how to adapt context to the portal or servlet mode and how to manage the init request and other requests.<br/>

 * @author Pierre Le Roux
 * @since 0.5.0
 */
public class ItcbVaadinApplicationConfig {
	
	private List<ItcbRequestInterceptor> requestInterceptors;
	
	private List<ItcbRequestInterceptor> initRequestInterceptors;
	
	private PortalAdapterProvider<Object> portalAdapterProvider;
	
	private Map<String, String> mapPageMappingProcessor;

	
	/**
	 * Set the portalAdapterProvider in order to have access to portal functionalities
	 * @param portalAdapterProvider
	 */
	@Required
	public void setPortalAdapterProvider(PortalAdapterProvider<Object> portalAdapterProvider) {
		this.portalAdapterProvider = portalAdapterProvider;
	}
	
	public PortalAdapterProvider<Object> getPortalAdapterProvider() {
		return portalAdapterProvider;
	}
	
	/**
	 * Map of :
	 * <ul>
	 * 	<li>key reference (used in request parameter <code>itcbmode</code> in servlet context or {@link PortletMode} in portlet request</li>
	 *  <li>spring bean name for the pageMappingProcessor to load.</li>
	 * </ul>
	 * It allows to declare all pageMappingProcessors used by the application depending on the mode.
	 * In order to be compliant with either servlet and portlet contexts, those modes have to declared :
	 * <ul>
	 * 	<li>view</li>
	 *  <li>edit</li>
	 *  <li>help</li>
	 * </ul>
	 * For servlet contexts others pageMappingProcessor can be declared.<br/>
	 * <b><font color="red">Warning : pageMappingProcessor and pages declarations must be done using <code>scope="prototype"</code></font></b>
	 * @param mapPageMappingProcessor map of String, String. {@link PageMappingProcessor} objects will be loaded at init or when user changes mode. Loading is done by {@link ItcbVaadinApplication} 
	 */
	@Required
	public void setMapPageMappingProcessor(
			Map<String, String> mapPageMappingProcessor) {
		this.mapPageMappingProcessor = mapPageMappingProcessor;
	}
	
	public Map<String, String> getMapPageMappingProcessor() {
		return mapPageMappingProcessor;
	}

	public List<ItcbRequestInterceptor> getItcbInitRequestInterceptors() {
		return initRequestInterceptors;
	}

	/**
	 * Interceptors that have to be called at application init. 
	 * It allows to deal with request at init which is not possible with vaadin {@link Application#init()} method.
	 * @param itcbInitRequestInterceptors list of interceptors
	 */
	public void setItcbInitRequestInterceptors(
			List<ItcbRequestInterceptor> itcbInitRequestInterceptors) {
		this.initRequestInterceptors = itcbInitRequestInterceptors;
	}
	
	/**
	 * 
	 * @return
	 */
	public List<ItcbRequestInterceptor> getItcbRequestInterceptors() {
		return requestInterceptors;
	}

	/**
	 * Interceptors that have to be called at each request
	 * @param itcbRequestInterceptors list of interceptors
	 */
	public void setItcbRequestInterceptors(List<ItcbRequestInterceptor> itcbRequestInterceptors) {
		this.requestInterceptors = itcbRequestInterceptors;
	}
	

}
