package net.sf.itcb.common.portlet.vaadin.interceptor.request.impl;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;

import net.sf.itcb.common.business.core.ItcbConstants;
import net.sf.itcb.common.portlet.vaadin.ItcbVaadinApplication;
import net.sf.itcb.common.portlet.vaadin.interceptor.request.ItcbRequestInterceptor;

public class MdcInterceptor implements ItcbRequestInterceptor {

	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	@Override
	public void handleRequestStart(ItcbVaadinApplication application,
			HttpServletRequest servletRequest) {
		if(application.getUser() != null) {
			MDC.put(ItcbConstants.MDC_USER_KEY, ((UsernamePasswordAuthenticationToken)application.getUser()).getName());
		}
		else {
			MDC.put(ItcbConstants.MDC_USER_KEY, "");
		}

	}

	@Override
	public void handleRequestStart(ItcbVaadinApplication application,
			PortletRequest portletRequest) {
		if(application.getUser() != null) {
			
			MDC.put(ItcbConstants.MDC_USER_KEY, ((UsernamePasswordAuthenticationToken)application.getUser()).getName());
		}
		else {
			MDC.put(ItcbConstants.MDC_USER_KEY, "");
		}


	}

	@Override
	public void handleRequestEnd(ItcbVaadinApplication application,
			HttpServletRequest servletRequest) {
		MDC.remove(ItcbConstants.MDC_USER_KEY);
	}

	@Override
	public void handleRequestEnd(ItcbVaadinApplication application,
			PortletRequest portletRequest) {
		MDC.remove(ItcbConstants.MDC_USER_KEY);
	}

}
