package net.sf.itcb.common.portlet.vaadin.interceptor.request;

import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.itcb.common.portlet.vaadin.ItcbVaadinApplication;

/**
 * This interface can be implemented to build your own interceptor to deal with init or all requests
 * Those interceptors are called by :
 * <ul>
 * 	<li>{@link ItcbVaadinApplication#onRequestStart(HttpServletRequest, HttpServletResponse)}</li>
 *  <li>{@link ItcbVaadinApplication#onRequestStart(PortletRequest, PortletResponse)}</li>
 * <ul>
 *  <li>handleRequestStart methods are called at init or at each request depending on the map in which interceptor has been injected : either {@link PageMappingProcessorConfig#setItcbInitRequestInterceptors(java.util.List)} or {@link PageMappingProcessorConfig#setItcbRequestInterceptors(java.util.List)} </li>
 *  <li>handleRequestEnd methods are called after init or before ending the request depending on the map in which interceptor has been injected</li>
 * <ul>
 * @since 0.5.0
 * @author Pierre Le Roux
 */
public interface ItcbRequestInterceptor {
	
	void handleRequestStart(ItcbVaadinApplication application, HttpServletRequest servletRequest);
	
	void handleRequestStart(ItcbVaadinApplication application, PortletRequest portletRequest); 
	
	void handleRequestEnd(ItcbVaadinApplication application, HttpServletRequest servletRequest);
	
	void handleRequestEnd(ItcbVaadinApplication application, PortletRequest portletRequest); 

}
