package net.sf.itcb.common.portlet.portal;

import java.util.Locale;
import java.util.Map;

import net.sf.itcb.common.portlet.exceptions.PortletItcbException;
import net.sf.itcb.common.portlet.exceptions.PortletItcbExceptionMappingErrors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

/**
 * This class defines in which portal the portlet is launched and give the portalAdapter associated
 * Mapping is done by the map <code>portalAdapters</code> injected by Spring.
 * 
 * @author Pierre Le Roux
 */
public class PortalAdapterProvider<T> {

	private static final long serialVersionUID = 1L;
	
	protected PortalAdapter<T> selectedPortalAdapter;
	
	protected Map<String, PortalAdapter<T>> portalAdapters;
	
	protected MessageSource itcbPortletMessageSource; 
	
	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	public PortalAdapterProvider(Map<String, PortalAdapter<T>> portalAdapters) {
		this.portalAdapters = portalAdapters;
	}
	
	public void setItcbPortletMessageSource(MessageSource messageSource) {
		itcbPortletMessageSource = messageSource;
	}

	public PortalAdapter<T> getPortalAdapter(T request) {
		if(selectedPortalAdapter != null) {
			return selectedPortalAdapter;
		}
		PortalAdapter<T> portalAdapter = portalAdapters.get(request.getClass().getName());
		if(portalAdapter != null) {
			selectedPortalAdapter= portalAdapter;
			return portalAdapter;
		}
		else {
			throw new PortletItcbException(PortletItcbExceptionMappingErrors.COMMON_PORTLET_NO_PORTAL_PROVIDER, itcbPortletMessageSource.getMessage("common.portlet.exception.no.portal.provider", null, Locale.getDefault()));
		}
		
	}
	
	

}
