package net.sf.itcb.common.portlet.portal;

import java.util.Map;

import javax.servlet.ServletRequest;

import org.springframework.security.core.userdetails.UserDetails;


public class InnerPortalAdapter {
		
		private PortalAdapter<Object> portalAdapter; 
		private Object request;
		
		public InnerPortalAdapter(PortalAdapter<Object> portalAdapter, Object request) {
			this.portalAdapter=portalAdapter;
			this.request=request;
		}
		
		/* Session scope */
		public UserDetails getUser() {
			return portalAdapter.getUser(request);
		}
		
		public ServletRequest getOriginalServletRequest() {
			return portalAdapter.getOriginalServletRequest(request);
		}
		
		public String getTheme() {
			return portalAdapter.getTheme(request);
		}
		
		public String getImpersonatedUser() {
			return portalAdapter.getImpersonatedUser(request);
		}
		
		
		/* Application scope */
		public Map<String, String[]> getApplicationPreferences() {
			return portalAdapter.getApplicationPreferences(request);
		}
		
		public void updateApplicationPreferences(Map<String, String[]> orders) {
			portalAdapter.updateApplicationPreferences(request, orders);
		}
		
	}