package net.sf.itcb.common.portlet.filter;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

import net.sf.itcb.common.business.core.ItcbConstants;

import org.slf4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This filter add the UserPrincipal in MDC context in order to log it with Log4J or other SL4J framework.<br/>
 * Example in log4j.xml pattern : %X{user}
 * @deprecated use {@link net.sf.itcb.common.portlet.vaadin.interceptor.impl.MdcInterceptor} in Spring context instead
 * @author Pierre Le Roux
 */
public class MdcFilter implements RenderFilter, ActionFilter, ResourceFilter, EventFilter {

	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	@Override
	public void init(FilterConfig filterConfig) throws PortletException {
		log.info("MdcFilter initialized");
	}

	@Override
	public void destroy() {
		log.info("MdcFilter destroyed");
	}

	@Override
	public void doFilter(RenderRequest request, RenderResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
	}

	@Override
	public void doFilter(ResourceRequest request, ResourceResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
	}

	@Override
	public void doFilter(ActionRequest request, ActionResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
	}

	@Override
	public void doFilter(EventRequest request, EventResponse response,
			FilterChain chain) throws IOException, PortletException {
		doFilterDelegate(request, response, chain);
		chain.doFilter(request, response);
	}
	
	protected void doFilterDelegate(PortletRequest request,
			PortletResponse response, FilterChain chain) throws IOException,
			PortletException {
		if(request.getRemoteUser() != null) {
			MDC.put(ItcbConstants.MDC_USER_KEY, request.getRemoteUser());
		}
		else {
			MDC.put(ItcbConstants.MDC_USER_KEY, "");
		}
	}

}
