package net.sf.itcb.common.portlet.exceptions;

import net.sf.itcb.common.business.exceptions.ExceptionMappingErrors;

/**
 * All problems that can occurs in client side when we call a webservice
 * 
 * @author Pierre Le Roux
 */
public enum PortletItcbExceptionMappingErrors implements ExceptionMappingErrors{
	
	COMMON_PORTLET_NO_PORTAL_PROVIDER ("No PortalAdapterProvider has been found for this PorletRequest"),
	COMMON_PORTLET_MISSING_PAGE ("The page doesn't exist in mapping declaration"), 
	COMMON_PORTLET_LOADING_PAGE ("Loading page failed"),
	COMMON_PORTLET_TYPE_ERROR_CONTROLLER("This method can't be called to retrieve a controller");
	
	private String message;
	
	PortletItcbExceptionMappingErrors(String msg) {
		this.message=msg;
	}

	public String getMessage() {
		return message;
	}
	
	public String getMessageKey() {
		return this.toString();
	}

}
