package net.sf.itcb.common.portlet.vaadin.page.impl;

import net.sf.itcb.common.business.core.ItcbApplicationContextHolder;
import net.sf.itcb.common.portlet.exceptions.PortletItcbException;
import net.sf.itcb.common.portlet.exceptions.PortletItcbExceptionMappingErrors;
import net.sf.itcb.common.portlet.vaadin.page.AbstractItcbPortletPage;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor.ReloadOrder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.annotation.Async;

public class PageMappingProcessorAsyncDelegate {
		
		public static final String HIDDEN_STYLE = "ITCB_HIDDEN_PRELOAD";
		protected final Logger log = LoggerFactory.getLogger(getClass());
		
		/**
		 * This function is called with async method in order to construct the page serverside without time issue for the user
		 * @param refPage the page to load
		 * @param reload reload or not or only if modified
		 * @param pageMappingProcessor application pageMappingProcessor
		 */
		@Async
		public void preloadPage(String refPage, ReloadOrder reload, PageMappingProcessorImpl pageMappingProcessor) {
			try  {
				synchronized(pageMappingProcessor.getApplication()) {
					log.debug("Preload {}", refPage);
					AbstractItcbPortletPage page = pageMappingProcessor.mapping.get(refPage);
					
					if(page == null) {
						MessageSource itcbPortletMessageSource = ItcbApplicationContextHolder.getContext().getBean("common-portletResources", MessageSource.class);
						throw new PortletItcbException(PortletItcbExceptionMappingErrors.COMMON_PORTLET_MISSING_PAGE, itcbPortletMessageSource.getMessage("common.portlet.exception.missing.page", new Object[] {refPage}, LocaleContextHolder.getLocale()));
					}
					pageMappingProcessor.loadPage(page, reload);	
					page.setVisible(true);
					page.addStyleName(HIDDEN_STYLE);
					pageMappingProcessor.progressIndicator.setEnabled(false);
				}
			}
			catch(final Exception e) {
				log.error(e.getMessage());
			}
		}
		
		
		
		
	}