package net.sf.itcb.common.portlet.portal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

import com.liferay.portal.model.Role;
import com.liferay.portal.util.PortalUtil;
/**
 * 
 * This class's aim is to transform a Liferay specific context in a common spring context.<br/>
 * In a first time, only user data are managed.<br/>
 * It's the only class using Liferay classes. When we use this class, it means that the framework saw that the porlet had been lauched in Liferay.<br/>
 * This class extends the standard {@link PortalAdapter}.<br/>
 * 
 * @author Pierre Le Roux
 *
 */
public class LiferayAdapter implements PortalAdapter, Serializable {

	private static final long serialVersionUID = 1L;
	
	protected final Logger log = LoggerFactory.getLogger(getClass());

	@Override
	public UserDetails getUser(PortletRequest request) {
		User userSpring =null;
		try {
			com.liferay.portal.model.User userLiferay = PortalUtil.getUser(request);
			if(userLiferay != null) {
				Collection<GrantedAuthority> grantedAutorithies = new ArrayList<GrantedAuthority>();
				
				List<Role> listRole = userLiferay.getRoles();
				for (Role role : listRole) {
					grantedAutorithies.add(new GrantedAuthorityImpl(role.getName()));
				}
				userSpring = new User(userLiferay.getLogin(), userLiferay.getPassword(), userLiferay.getActive(), !userLiferay.getLockout(), userLiferay.getAgreedToTermsOfUse(), !userLiferay.getLockout(), grantedAutorithies);
				
			}
		} catch (Exception e1) {
			// If an exception is thrown, no action.
			log.error("Unexpected error occurs : {}", e1.getMessage());
			if(log.isDebugEnabled()) {
				e1.printStackTrace();
			}
		}
		return userSpring;
	}

	@Override
	public ServletRequest getServletRequest(PortletRequest request) {
		HttpServletRequest servletRequest = PortalUtil.getHttpServletRequest(request);
		servletRequest = PortalUtil.getOriginalServletRequest(servletRequest);
		
		return servletRequest;
	}

}
