/*
 * Decompiled with CFR 0.152.
 */
package net.sf.itcb.common.portlet.vaadin.page.impl;

import com.vaadin.terminal.ParameterHandler;
import com.vaadin.terminal.Terminal;
import com.vaadin.terminal.URIHandler;
import com.vaadin.terminal.VariableOwner;
import com.vaadin.terminal.gwt.server.ChangeVariablesErrorEvent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;
import net.sf.itcb.common.business.core.ItcbApplicationContextHolder;
import net.sf.itcb.common.portlet.exceptions.PortletItcbException;
import net.sf.itcb.common.portlet.exceptions.PortletItcbExceptionMappingErrors;
import net.sf.itcb.common.portlet.portal.PortalAdapterProvider;
import net.sf.itcb.common.portlet.vaadin.AbstractItcbPortletApplication;
import net.sf.itcb.common.portlet.vaadin.exception.ExceptionHandlerMapping;
import net.sf.itcb.common.portlet.vaadin.page.AbstractItcbPortletPage;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class PageMappingProcessorImpl
implements PageMappingProcessor,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, AbstractItcbPortletPage> mapping;
    protected String defaultPageKey;
    protected ExceptionHandlerMapping exceptionHandlerMapping;
    protected Panel panel;
    protected PortletRequest portletRequest;
    protected ServletRequest servletRequest;
    protected AbstractItcbPortletApplication application;
    protected AbstractItcbPortletPage currentPage;
    protected LinkedList<String> pageHistory = new LinkedList();
    protected static PortalAdapterProvider portalAdapterProvider = (PortalAdapterProvider)ItcbApplicationContextHolder.getContext().getBean("itcbPortalAdapterProvider", PortalAdapterProvider.class);
    protected Boolean isAutomaticDisplay = true;

    @Override
    public void setMapping(Map<String, AbstractItcbPortletPage> mapping) {
        this.mapping = mapping;
    }

    @Override
    public void setDefaultPageKey(String defaultPageKey) {
        this.defaultPageKey = defaultPageKey;
    }

    @Override
    public void setIsAutomaticDisplay(Boolean isAutomaticDisplay) {
        this.isAutomaticDisplay = isAutomaticDisplay;
    }

    @Override
    public void setExceptionHandlerMapping(ExceptionHandlerMapping exceptionHandlerMapping) {
        this.exceptionHandlerMapping = exceptionHandlerMapping;
    }

    @Override
    public void setRequest(PortletRequest request) {
        this.portletRequest = request;
        this.servletRequest = portalAdapterProvider.getPortalAdapter(request).getServletRequest(request);
    }

    @Override
    public void setRequest(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    @Override
    public void setPanel(Panel panel) {
        this.panel = panel;
    }

    @Override
    public void setApplication(AbstractItcbPortletApplication application) {
        this.application = application;
    }

    @Override
    public AbstractItcbPortletApplication getApplication() {
        return this.application;
    }

    @Override
    public void displayPage(String refPage, boolean reload) {
        if (reload) {
            this.displayPage(refPage, PageMappingProcessor.ReloadOrder.TRUE);
        } else {
            this.displayPage(refPage, PageMappingProcessor.ReloadOrder.FALSE);
        }
    }

    @Override
    public void displayPage(String refPage, boolean reload, boolean closeApplicationOnExit) {
        this.application.setHasToCloseApplicationOnExit(closeApplicationOnExit);
        this.displayPage(refPage, reload);
    }

    @Override
    public void displayPage(String refPage, PageMappingProcessor.ReloadOrder reload) {
        try {
            this.log.debug("Display {}", (Object)refPage);
            AbstractItcbPortletPage page = this.mapping.get(refPage);
            if (page == null) {
                MessageSource itcbPortletMessageSource = (MessageSource)ItcbApplicationContextHolder.getContext().getBean("common-portletResources", MessageSource.class);
                throw new PortletItcbException(PortletItcbExceptionMappingErrors.COMMON_PORTLET_MISSING_PAGE, itcbPortletMessageSource.getMessage("common.portlet.exception.missing.page", new Object[]{refPage}, LocaleContextHolder.getLocale()));
            }
            if (this.currentPage != null && this.currentPage != page) {
                this.currentPage.setVisible(false);
            }
            if (page != null && (reload == PageMappingProcessor.ReloadOrder.TRUE || reload == PageMappingProcessor.ReloadOrder.IF_MODIFIED && page.hasChangedSinceLastDisplay())) {
                page.setPageMappingProcessor(this);
                page.removeAllComponents();
                page.initPage();
                if (page.getParent() == null) {
                    this.panel.addComponent((Component)page);
                }
            }
            if (page.getPageMappingProcessor() == null || page.getParent() == null || !page.getComponentIterator().hasNext()) {
                page.setPageMappingProcessor(this);
                page.initPage();
                this.panel.addComponent((Component)page);
            }
            page.setVisible(true);
            this.currentPage = page;
            if (this.pageHistory.size() > 0) {
                if (refPage.compareTo(this.pageHistory.getLast()) != 0) {
                    this.pageHistory.add(refPage);
                }
            } else {
                this.pageHistory.add(refPage);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            MessageSource itcbPortletMessageSource = (MessageSource)ItcbApplicationContextHolder.getContext().getBean("common-portletResources", MessageSource.class);
            throw new PortletItcbException(PortletItcbExceptionMappingErrors.COMMON_PORTLET_LOADING_PAGE, itcbPortletMessageSource.getMessage("common.portlet.exception.loading.page", new Object[]{refPage, e.getMessage()}, LocaleContextHolder.getLocale()));
        }
    }

    @Override
    public void displayPage(String refPage, PageMappingProcessor.ReloadOrder reload, boolean closeApplicationOnExit) {
        this.application.setHasToCloseApplicationOnExit(closeApplicationOnExit);
        this.displayPage(refPage, reload);
    }

    @Override
    public void displayDefaultPage() {
        this.log.debug("Display the default page {}", (Object)this.defaultPageKey);
        if (this.defaultPageKey != null) {
            this.panel.setContent(null);
            for (AbstractItcbPortletPage page : this.mapping.values()) {
                page.setParent(null);
            }
            this.displayPage(this.defaultPageKey, true);
        } else if (this.log.isDebugEnabled()) {
            this.log.warn("No default page configured. PageMappingProcessor mecanism not used. Set the defaultPageKey property in your spring context.");
        }
    }

    @Override
    public void displayPreviousPage() {
        if (this.pageHistory.size() >= 2) {
            String previousPage = this.pageHistory.get(this.pageHistory.size() - 2);
            this.displayPage(previousPage, false);
            this.pageHistory.pollLast();
            this.pageHistory.pollLast();
        } else {
            this.log.error("You can't display a previous page because no previous page exists");
        }
    }

    @Override
    public boolean hasPreviousPage() {
        return this.pageHistory.size() >= 1;
    }

    @Override
    public void setSessionAttribute(String key, Object value) {
        this.portletRequest.getPortletSession().setAttribute(key, value);
    }

    @Override
    public <T> T getSessionAttribute(String key, Class<T> requiredType) {
        return (T)this.portletRequest.getPortletSession().getAttribute(key);
    }

    @Override
    public <T> T getSharedSessionAttribute(String key, Class<T> requiredType) {
        return (T)this.portletRequest.getPortletSession().getAttribute(key, 1);
    }

    @Override
    public PortletRequest getRequest() {
        return this.portletRequest;
    }

    @Override
    public boolean isAutomaticDisplay() {
        return this.isAutomaticDisplay;
    }

    @Override
    public void handleException(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        MessageSource itcbPortletMessageSource = (MessageSource)ItcbApplicationContextHolder.getContext().getBean("common-portletResources", MessageSource.class);
        throw new PortletItcbException(PortletItcbExceptionMappingErrors.COMMON_PORTLET_LOADING_PAGE, itcbPortletMessageSource.getMessage("common.portlet.exception.loading.page", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale()));
    }

    @Override
    public void handleError(Terminal.ErrorEvent error) {
        try {
            if (this.exceptionHandlerMapping != null) {
                this.exceptionHandlerMapping.handleError(error, this);
            } else {
                Throwable t = error.getThrowable().getCause();
                if (t != null) {
                    this.log.error(t.getMessage(), t);
                }
            }
        }
        catch (Exception exceptionInExceptionManagement) {
            this.log.error("The exception has not been handled well {}. This Exception occured {}", (Object)error.getThrowable(), (Object)exceptionInExceptionManagement);
        }
    }

    @Override
    public String getRequestParameter(String key) {
        String value = this.portletRequest.getParameter(key);
        if (value == null) {
            value = this.servletRequest.getParameter(key);
        }
        return value;
    }

    @Override
    public Object getErrorOwner(Terminal.ErrorEvent event) {
        VariableOwner owner = null;
        if (event instanceof VariableOwner.ErrorEvent) {
            owner = ((VariableOwner.ErrorEvent)event).getVariableOwner();
        } else if (event instanceof URIHandler.ErrorEvent) {
            owner = ((URIHandler.ErrorEvent)event).getURIHandler();
        } else if (event instanceof ParameterHandler.ErrorEvent) {
            owner = ((ParameterHandler.ErrorEvent)event).getParameterHandler();
        } else if (event instanceof ChangeVariablesErrorEvent) {
            owner = ((ChangeVariablesErrorEvent)event).getComponent();
        }
        return owner;
    }
}

