/*
 * Decompiled with CFR 0.152.
 */
package net.sf.itcb.common.portlet.vaadin.page;

import com.vaadin.data.Property;
import com.vaadin.ui.VerticalLayout;
import java.util.HashMap;
import java.util.Map;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItcbPortletPage
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private PageMappingProcessor pageMappingProcessor;
    private Map<Property.ValueChangeNotifier, Boolean> listenedFieldsForChanges;
    private FieldValueChangeListener fieldValueChangeListener;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PageMappingProcessor getPageMappingProcessor() {
        return this.pageMappingProcessor;
    }

    public void initPage() throws Exception {
        this.log.debug("Initializing {}", ((Object)((Object)this)).getClass());
        this.removeAllComponents();
        this.setMargin(false);
        this.setSpacing(false);
        this.defineContentDelegate();
        if (this instanceof FieldsValuePreLoadable) {
            ((FieldsValuePreLoadable)((Object)this)).fillFieldsWithValues();
        }
    }

    protected abstract void defineContentDelegate() throws Exception;

    public void setPageMappingProcessor(PageMappingProcessor pageMappingProcessor) {
        this.pageMappingProcessor = pageMappingProcessor;
    }

    public void addFieldToListenForChange(Property.ValueChangeNotifier component) {
        if (this.listenedFieldsForChanges == null) {
            this.listenedFieldsForChanges = new HashMap<Property.ValueChangeNotifier, Boolean>();
            this.fieldValueChangeListener = new FieldValueChangeListener();
        }
        this.listenedFieldsForChanges.put(component, Boolean.FALSE);
        component.addListener((Property.ValueChangeListener)this.fieldValueChangeListener);
    }

    public boolean hasChangedSinceLastDisplay() {
        if (this.listenedFieldsForChanges != null) {
            for (Boolean fieldHasChanged : this.listenedFieldsForChanges.values()) {
                if (!fieldHasChanged.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    protected class FieldValueChangeListener
    implements Property.ValueChangeListener {
        private static final long serialVersionUID = 1L;

        protected FieldValueChangeListener() {
        }

        public void valueChange(Property.ValueChangeEvent event) {
            AbstractItcbPortletPage.this.listenedFieldsForChanges.put((Property.ValueChangeNotifier)event.getProperty(), Boolean.TRUE);
        }
    }

    protected static interface FieldsValuePreLoadable {
        public void fillFieldsWithValues();
    }
}

