/*
 * Decompiled with CFR 0.152.
 */
package net.sf.itcb.common.portlet.vaadin.exception.impl;

import com.vaadin.terminal.Terminal;
import net.sf.itcb.common.portlet.vaadin.exception.ExceptionHandler;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class PageRedirectExceptionHandler
implements ExceptionHandler {
    private String errorPageKey;
    private String exceptionInSessionKey;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Required
    public void setErrorPageKey(String errorPageKey) {
        this.errorPageKey = errorPageKey;
    }

    public void setExceptionInSessionKey(String exceptionInSessionKey) {
        this.exceptionInSessionKey = exceptionInSessionKey;
    }

    @Override
    public void handleError(Terminal.ErrorEvent error, PageMappingProcessor pageMappingProcessor) {
        if (this.errorPageKey == null) {
            this.log.error("the errorPageKey must be declared in Spring configuration for this bean");
        }
        if (this.exceptionInSessionKey != null) {
            pageMappingProcessor.setSessionAttribute(this.exceptionInSessionKey, error.getThrowable().getCause());
            pageMappingProcessor.displayPage(this.errorPageKey, true);
        } else {
            pageMappingProcessor.displayPage(this.errorPageKey, false);
        }
    }
}

