/*
 * Decompiled with CFR 0.152.
 */
package net.sf.itcb.common.portlet.vaadin.exception;

import com.vaadin.terminal.Terminal;
import java.util.HashMap;
import java.util.Map;
import net.sf.itcb.common.portlet.vaadin.exception.ExceptionHandler;
import net.sf.itcb.common.portlet.vaadin.page.impl.PageMappingProcessorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class ExceptionHandlerMapping {
    private Map<Class, ExceptionHandler> exceptionMapping;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public ExceptionHandlerMapping() {
        this.exceptionMapping = new HashMap<Class, ExceptionHandler>();
    }

    @Required
    public void setExceptionMapping(Map<String, ExceptionHandler> exceptionMapping) {
        this.log.debug("Initializing exception handlers...");
        try {
            for (Map.Entry<String, ExceptionHandler> entry : exceptionMapping.entrySet()) {
                this.log.debug("{} Specific handler set", (Object)entry.getKey());
                this.exceptionMapping.put(Class.forName(entry.getKey()), entry.getValue());
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error("ExceptionHandlerMapping is not set because a class doesn't exist in classpath.", (Throwable)cnfe);
        }
    }

    public void handleError(Terminal.ErrorEvent error, PageMappingProcessorImpl pageMappingProcessor) {
        Throwable t;
        if (error != null && (t = error.getThrowable().getCause()) != null) {
            ExceptionHandler handler = this.exceptionMapping.get(t.getClass());
            if (handler == null) {
                for (Class entry : this.exceptionMapping.keySet()) {
                    if (!entry.isInstance(t)) continue;
                    handler = this.exceptionMapping.get(entry);
                    break;
                }
            }
            if (handler != null) {
                handler.handleError(error, pageMappingProcessor);
                return;
            }
        }
        this.log.error("An unexpected error occurs : ", (Object)error.getThrowable().getMessage());
    }
}

