/*
 * Decompiled with CFR 0.152.
 */
package net.sf.itcb.common.portlet.vaadin;

import com.vaadin.Application;
import com.vaadin.terminal.ErrorMessage;
import com.vaadin.terminal.ParameterHandler;
import com.vaadin.terminal.SystemError;
import com.vaadin.terminal.Terminal;
import com.vaadin.terminal.URIHandler;
import com.vaadin.terminal.VariableOwner;
import com.vaadin.terminal.gwt.server.ChangeVariablesErrorEvent;
import com.vaadin.terminal.gwt.server.HttpServletRequestListener;
import com.vaadin.terminal.gwt.server.PortletApplicationContext2;
import com.vaadin.terminal.gwt.server.WebApplicationContext;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.net.SocketException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.itcb.common.business.core.ItcbApplicationContextHolder;
import net.sf.itcb.common.portlet.vaadin.PanelSpecificPortlet;
import net.sf.itcb.common.portlet.vaadin.page.PageMappingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItcbPortletApplication
extends Application
implements HttpServletRequestListener,
PortletApplicationContext2.PortletListener {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Window mainWindow;
    protected String preferencesURL;
    protected PageMappingProcessor viewModePageMappingProcessor;
    protected PageMappingProcessor editModePageMappingProcessor;
    protected PageMappingProcessor helpModePageMappingProcessor;
    protected PageMappingProcessor currentPageMappingProcessor;
    protected boolean hasToCloseApplicationOnExit = false;
    private HttpServletRequest servletRequest = null;

    public void init() {
        this.viewModePageMappingProcessor = (PageMappingProcessor)ItcbApplicationContextHolder.getContext().getBean("viewModePageMappingProcessor", PageMappingProcessor.class);
        this.editModePageMappingProcessor = (PageMappingProcessor)ItcbApplicationContextHolder.getContext().getBean("editModePageMappingProcessor", PageMappingProcessor.class);
        this.helpModePageMappingProcessor = (PageMappingProcessor)ItcbApplicationContextHolder.getContext().getBean("helpModePageMappingProcessor", PageMappingProcessor.class);
        this.mainWindow = new Window(this.getWindowName());
        this.setMainWindow(this.mainWindow);
        if (this.getContext() instanceof PortletApplicationContext2) {
            PortletApplicationContext2 ctx = (PortletApplicationContext2)this.getContext();
            this.log.debug("init" + this.getUser());
            ctx.addPortletListener((Application)this, (PortletApplicationContext2.PortletListener)this);
        } else if (this.getContext() instanceof WebApplicationContext) {
            WebApplicationContext ctx = (WebApplicationContext)this.getContext();
            this.manageServletContext(ctx);
        }
        this.mainWindow.addListener(new Window.CloseListener(){
            private static final long serialVersionUID = 1L;

            public void windowClose(Window.CloseEvent poEvent) {
                AbstractItcbPortletApplication.this.log.debug("Closing Application window");
                if (AbstractItcbPortletApplication.this.hasToCloseApplicationOnExit) {
                    AbstractItcbPortletApplication.this.mainWindow = null;
                    AbstractItcbPortletApplication.this.close();
                }
            }
        });
    }

    public void terminalError(Terminal.ErrorEvent event) {
        Throwable t = event.getThrowable();
        if (t instanceof SocketException) {
            return;
        }
        VariableOwner owner = null;
        if (event instanceof VariableOwner.ErrorEvent) {
            owner = ((VariableOwner.ErrorEvent)event).getVariableOwner();
        } else if (event instanceof URIHandler.ErrorEvent) {
            owner = ((URIHandler.ErrorEvent)event).getURIHandler();
        } else if (event instanceof ParameterHandler.ErrorEvent) {
            owner = ((ParameterHandler.ErrorEvent)event).getParameterHandler();
        } else if (event instanceof ChangeVariablesErrorEvent) {
            owner = ((ChangeVariablesErrorEvent)event).getComponent();
        }
        if (owner instanceof AbstractComponent && !(owner instanceof Button)) {
            if (t instanceof ErrorMessage) {
                ((AbstractComponent)owner).setComponentError((ErrorMessage)t);
            } else {
                ((AbstractComponent)owner).setComponentError((ErrorMessage)new SystemError(t));
            }
        }
        this.log.error("Terminal error:", t);
        try {
            this.currentPageMappingProcessor.handleError(event);
        }
        catch (Exception errorInExceptionManagementException) {
            errorInExceptionManagementException.printStackTrace();
        }
    }

    public void onRequestStart(HttpServletRequest request, HttpServletResponse response) {
        this.servletRequest = request;
    }

    public void onRequestEnd(HttpServletRequest request, HttpServletResponse response) {
    }

    private void manageServletContext(WebApplicationContext ctx) {
        this.mainWindow.removeAllComponents();
        TabSheet modeTabs = new TabSheet();
        modeTabs.setSizeFull();
        VerticalLayout viewPanel = new VerticalLayout();
        viewPanel.setSizeFull();
        VerticalLayout editPanel = new VerticalLayout();
        editPanel.setSizeFull();
        VerticalLayout helpPanel = new VerticalLayout();
        helpPanel.setSizeFull();
        modeTabs.addTab((Component)viewPanel, PortletMode.VIEW.toString(), null);
        modeTabs.addTab((Component)editPanel, PortletMode.EDIT.toString(), null);
        modeTabs.addTab((Component)helpPanel, PortletMode.HELP.toString(), null);
        modeTabs.setSelectedTab((Component)viewPanel);
        this.currentPageMappingProcessor = this.viewModePageMappingProcessor;
        modeTabs.addListener(new TabSheet.SelectedTabChangeListener(){
            private static final long serialVersionUID = 1L;

            public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                TabSheet tabsheet = event.getTabSheet();
                TabSheet.Tab tab = tabsheet.getTab(tabsheet.getSelectedTab());
                if (PortletMode.VIEW.equals((Object)tab.getCaption())) {
                    AbstractItcbPortletApplication.this.currentPageMappingProcessor = AbstractItcbPortletApplication.this.viewModePageMappingProcessor;
                } else if (PortletMode.EDIT.equals((Object)tab.getCaption())) {
                    AbstractItcbPortletApplication.this.currentPageMappingProcessor = AbstractItcbPortletApplication.this.editModePageMappingProcessor;
                } else if (PortletMode.HELP.equals((Object)tab.getCaption())) {
                    AbstractItcbPortletApplication.this.currentPageMappingProcessor = AbstractItcbPortletApplication.this.helpModePageMappingProcessor;
                }
                AbstractItcbPortletApplication.this.currentPageMappingProcessor.setRequest((ServletRequest)AbstractItcbPortletApplication.this.servletRequest);
                AbstractItcbPortletApplication.this.currentPageMappingProcessor.setApplication(AbstractItcbPortletApplication.this);
                if (AbstractItcbPortletApplication.this.currentPageMappingProcessor.isAutomaticDisplay()) {
                    AbstractItcbPortletApplication.this.currentPageMappingProcessor.displayDefaultPage();
                }
            }
        });
        this.mainWindow.addComponent((Component)modeTabs);
    }

    public void setHasToCloseApplicationOnExit(boolean hasToCloseApplicationOnExit) {
        this.hasToCloseApplicationOnExit = hasToCloseApplicationOnExit;
    }

    public PageMappingProcessor getCurrentPageMappingProcessor() {
        return this.currentPageMappingProcessor;
    }

    protected String getWindowName() {
        return "";
    }

    protected Panel getComponentContainer(PortletMode portletMode) {
        if (this instanceof PanelSpecificPortlet) {
            if (PortletMode.VIEW.equals((Object)portletMode)) {
                return ((PanelSpecificPortlet)((Object)this)).getPanelView();
            }
            if (PortletMode.EDIT.equals((Object)portletMode)) {
                return ((PanelSpecificPortlet)((Object)this)).getPanelEdit();
            }
            if (PortletMode.HELP.equals((Object)portletMode)) {
                return ((PanelSpecificPortlet)((Object)this)).getPanelHelp();
            }
        }
        return this.getMainWindow();
    }

    public void handleActionRequest(ActionRequest request, ActionResponse response, Window window) {
    }

    public void handleRenderRequest(RenderRequest request, RenderResponse response, Window window) {
        if (this.preferencesURL == null) {
            PortletURL url = response.createActionURL();
            try {
                url.setPortletMode(PortletMode.EDIT);
                url.setWindowState(WindowState.MAXIMIZED);
                this.preferencesURL = url.toString();
            }
            catch (PortletModeException e) {
                this.log.warn(e.getMessage());
            }
            catch (WindowStateException e) {
                this.log.warn(e.getMessage());
            }
        }
        try {
            if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
                this.currentPageMappingProcessor = this.viewModePageMappingProcessor;
            } else if (PortletMode.EDIT.equals((Object)request.getPortletMode())) {
                this.currentPageMappingProcessor = this.editModePageMappingProcessor;
            } else if (PortletMode.HELP.equals((Object)request.getPortletMode())) {
                this.currentPageMappingProcessor = this.helpModePageMappingProcessor;
            }
            if (this.currentPageMappingProcessor == null) {
                this.log.error("the " + request.getPortletMode() + " associated mapping variable has to be set in spring context. The bean name has to be : " + request.getPortletMode() + "ModePageMappingProcessor");
                return;
            }
            this.currentPageMappingProcessor.setRequest((PortletRequest)request);
            this.currentPageMappingProcessor.setPanel(this.getComponentContainer(request.getPortletMode()));
            this.currentPageMappingProcessor.setApplication(this);
            if (this.currentPageMappingProcessor.isAutomaticDisplay()) {
                this.currentPageMappingProcessor.displayDefaultPage();
            }
        }
        catch (Exception e) {
            try {
                this.currentPageMappingProcessor.handleException(e);
            }
            catch (Exception errorInExceptionManagementException) {
                errorInExceptionManagementException.printStackTrace();
            }
        }
    }

    public void handleEventRequest(EventRequest request, EventResponse response, Window window) {
    }

    public void handleResourceRequest(ResourceRequest request, ResourceResponse response, Window window) {
    }
}

