/*
 * Decompiled with CFR 0.152.
 */
package net.sf.itcb.common.portlet.portal;

import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import net.sf.itcb.common.portlet.exceptions.PortletItcbException;
import net.sf.itcb.common.portlet.exceptions.PortletItcbExceptionMappingErrors;
import net.sf.itcb.common.portlet.portal.PortalAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class PortalAdapterProvider {
    private static final long serialVersionUID = 1L;
    protected PortalAdapter selectedPortalAdapter;
    protected Map<String, PortalAdapter> portalAdapters;
    protected MessageSource itcbPortletMessageSource;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public PortalAdapterProvider(Map<String, PortalAdapter> portalAdapters) {
        this.portalAdapters = portalAdapters;
    }

    public void setItcbPortletMessageSource(MessageSource messageSource) {
        this.itcbPortletMessageSource = messageSource;
    }

    public PortalAdapter getPortalAdapter(PortletRequest request) {
        if (this.selectedPortalAdapter != null) {
            return this.selectedPortalAdapter;
        }
        PortalAdapter portalAdapter = this.portalAdapters.get(request.getClass().getName());
        if (portalAdapter != null) {
            this.selectedPortalAdapter = portalAdapter;
            return portalAdapter;
        }
        throw new PortletItcbException(PortletItcbExceptionMappingErrors.COMMON_PORTLET_NO_PORTAL_PROVIDER, this.itcbPortletMessageSource.getMessage("common.portlet.exception.no.portal.provider", null, Locale.getDefault()));
    }
}

