/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/

package ingenias.generator.browser;

import ingenias.exception.NullEntity;


// It represents a relationship extreme. It can contain attributes.
public interface GraphRole extends AttributedElement {
  // Obtains the entity that occupies this extreme of the relationship
  public GraphEntity getPlayer() throws NullEntity;
  // Name of this extreme of relationship
  public String getName();

  // returns the underlying roleentity in themodel
  public ingenias.editor.entities.RoleEntity getRoleEntity();
}