/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/

package ingenias.generator.browser;

import java.util.Iterator;

// It represents a relationship in a diagram. It can contain attributes.
public interface GraphRelationship extends AttributedElement {

   // Obtains the type of the relationship
   public String getType();

   // Obtains the extremes of the relationship
   public GraphRole[] getRoles();
   public GraphRole[] getRoles(String roleName);
   
   // returns the corresponding model entity
   public ingenias.editor.entities.NAryEdgeEntity getNAryEdge();
   
   // Obtains the graph which this relationship belongs to
   public Graph getGraph();
   
   // Obtains the id of this relationship. This ID is autogenerated 
   // by the environment and cannot be modified by users,so it 
   // is not user friendly
   public String getID();

}