/*
 * Decompiled with CFR 0.152.
 */
package ingenias.codeproc;

import ingenias.editor.Log;
import ingenias.editor.ModelJGraph;
import ingenias.editor.ProjectProperty;
import ingenias.editor.extension.BasicCodeGeneratorImp;
import ingenias.exception.NotFound;
import ingenias.exception.NullEntity;
import ingenias.generator.browser.Browser;
import ingenias.generator.browser.Graph;
import ingenias.generator.browser.GraphEntity;
import ingenias.generator.browser.GraphEntityImp;
import ingenias.generator.browser.GraphRelationship;
import ingenias.generator.browser.GraphRole;
import ingenias.generator.datatemplate.Repeat;
import ingenias.generator.datatemplate.Sequences;
import ingenias.generator.datatemplate.Var;
import ingenias.generator.util.Conversor;
import java.awt.Frame;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

public class HTMLDocumentGenerator
extends BasicCodeGeneratorImp {
    public HTMLDocumentGenerator(String file) throws Exception {
        super(file);
        this.addTemplate("templates/index.xml");
        this.addTemplate("templates/diagram.xml");
    }

    public HTMLDocumentGenerator(Browser browser) throws Exception {
        super(browser);
        this.addTemplate("templates/index.xml");
        this.addTemplate("templates/diagram.xml");
    }

    public String getVersion() {
        return "@modhtmldoc.ver@";
    }

    public boolean verify() {
        return true;
    }

    public Vector<ProjectProperty> defaultProperties() {
        Vector<ProjectProperty> result = new Vector<ProjectProperty>();
        Properties p = new Properties();
        result.add(new ProjectProperty(this.getName(), "htmldoc", "HTML document folder", "html", "The document folder that will contain HTML version of this specification"));
        return result;
    }

    public String getName() {
        return "HTML Document generator";
    }

    public String getDescription() {
        return "It generates HTML documentation of your diagrams";
    }

    public Sequences generate() {
        Sequences seq = new Sequences();
        try {
            this.generateIndex(seq);
            this.generatePages(seq);
            this.copyResourceFromTo("logograsia.jpg", this.getProperty((String)"htmldoc:output").value + "/logograsia.jpg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return seq;
    }

    private String[] toArray(String path) {
        StringTokenizer st = new StringTokenizer(path);
        int tokens = st.countTokens();
        String[] result = new String[tokens];
        for (int k = 0; k < tokens; ++k) {
            result[k] = st.nextToken();
        }
        return result;
    }

    private String toSafeName(String name) {
        name = name.replace('/', '_');
        name = name.replace('\\', '_');
        name = name.replace(' ', '_');
        return name;
    }

    private void generateIndex(Sequences p) throws Exception {
        Graph[] gs = this.browser.getGraphs();
        p.addVar(new Var("output", this.getProperty((String)"htmldoc:output").value));
        System.err.println("output:" + this.getProperty((String)"htmldoc:output").value);
        Hashtable pathtable = new Hashtable();
        Hashtable paths = new Hashtable();
        Hashtable depth = new Hashtable();
        Vector<String> alreadyShown = new Vector<String>();
        float increment = 25.0f / (float)gs.length;
        for (int k = 0; k < gs.length; ++k) {
            Repeat rp1 = null;
            this.setProgress((int)((float)k * increment));
            String[] path = gs[k].getPath();
            boolean already = true;
            while (already) {
                rp1 = new Repeat("paquete");
                p.addRepeat(rp1);
                int j = 0;
                for (j = 0; j < path.length - 1 && already; ++j) {
                    Repeat level = new Repeat("level");
                    rp1.add(level);
                    if (alreadyShown.contains(path[j])) continue;
                    already = false;
                    alreadyShown.add(path[j]);
                }
                if (!already) {
                    Repeat onlypackage = new Repeat("onlypackage");
                    rp1.add(onlypackage);
                    onlypackage.add(new Var("name", path[j - 1]));
                    already = true;
                    continue;
                }
                already = false;
            }
            Graph g = gs[k];
            Repeat rp2 = new Repeat("graph");
            rp2.add(new Var("name", Conversor.replaceInvalidCharsForID((String)g.getName())));
            rp2.add(new Var("fname", this.toSafeName(g.getName())));
            rp2.add(new Var("tipo", g.getType()));
            rp2.add(new Var("image", this.toSafeName(g.getName()) + ".png"));
            g.generateImage(this.getProperty((String)"htmldoc:output").value + "/" + this.toSafeName(g.getName()) + ".png");
            rp1.add(rp2);
        }
    }

    private void generatePages(Sequences p) throws Exception {
        Graph[] gs = this.browser.getGraphs();
        float increment = 25.0f / (float)gs.length;
        for (int k = 0; k < gs.length; ++k) {
            Graph g = gs[k];
            Repeat r = new Repeat("graph1");
            this.setProgress(25 + (int)((float)k * increment));
            p.addRepeat(r);
            r.add(new Var("output", this.getProperty((String)"htmldoc:output").value));
            r.add(new Var("name", gs[k].getName()));
            r.add(new Var("fname", this.toSafeName(gs[k].getName())));
            r.add(new Var("image", this.toSafeName(gs[k].getName()) + ".png"));
            r.add(new Var("tipo", gs[k].getType()));
            try {
                System.err.println("adding" + gs[k].getAttributeByName("Description").getSimpleValue());
                r.add(new Var("description", gs[k].getAttributeByName("Description").getSimpleValue()));
            }
            catch (NotFound nf) {
                nf.printStackTrace();
            }
            GraphEntity[] gesWithDups = g.getEntitiesWithDuplicates();
            for (int j = 0; j < gesWithDups.length; ++j) {
                Repeat ens = new Repeat("mapentities");
                GraphEntity ge = gesWithDups[j];
                GraphEntityImp gei = (GraphEntityImp)ge;
                DefaultGraphCell dgc1 = gei.getDgc();
                AttributeMap attributes = dgc1.getAttributes();
                Rectangle2D bounds = GraphConstants.getBounds((Map)attributes);
                ens.add(new Var("coordrect", "" + (int)bounds.getMinX() + "," + (int)bounds.getMinY() + "," + (int)bounds.getMaxX() + "," + (int)bounds.getMaxY()));
                ens.add(new Var("link", "" + ge.getID()));
                r.add(ens);
            }
            GraphEntity[] ges = g.getEntities();
            for (int j = 0; j < ges.length; ++j) {
                Repeat ens = new Repeat("entities");
                GraphEntity ge = ges[j];
                GraphEntityImp gei = (GraphEntityImp)ge;
                DefaultGraphCell dgc1 = gei.getDgc();
                AttributeMap attributes = dgc1.getAttributes();
                Rectangle2D bounds = GraphConstants.getBounds((Map)attributes);
                ens.add(new Var("coordrect", "" + (int)bounds.getMinX() + "," + (int)bounds.getMinY() + "," + (int)bounds.getMaxX() + "," + (int)bounds.getMaxY()));
                ens.add(new Var("link", "" + ge.getID()));
                ens.add(new Var("name", ge.getID()));
                ens.add(new Var("tipo", ge.getType()));
                try {
                    ens.add(new Var("description", ge.getAttributeByName("Description").getSimpleValue()));
                }
                catch (NotFound nf) {
                    // empty catch block
                }
                StringBuffer result = new StringBuffer();
                for (int m = 0; m < gs.length; ++m) {
                    try {
                        GraphEntity[] dges = gs[m].getEntities();
                        boolean found = false;
                        Vector<String> mentioned = new Vector<String>();
                        for (int l = 0; l < dges.length; ++l) {
                            found = dges[l].getID().equals(ge.getID());
                            if (!found || mentioned.contains(gs[m].getName())) continue;
                            Repeat diagram = new Repeat("relateddiagrams");
                            diagram.add(new Var("diagramname", this.toSafeName(gs[m].getName())));
                            diagram.add(new Var("diagramtype", gs[m].getType()));
                            ens.add(diagram);
                            mentioned.add(gs[k].getName());
                        }
                        continue;
                    }
                    catch (NullEntity e1) {
                        e1.printStackTrace();
                    }
                }
                GraphRelationship[] gr = ge.getRelationships();
                for (int i = 0; i < gr.length; ++i) {
                    Repeat rels = new Repeat("relationship");
                    Repeat meRel = new Repeat("mapentry");
                    rels.add(meRel);
                    meRel.add(new Var("coordrect", "0,0,115,33"));
                    meRel.add(new Var("link", "#link"));
                    rels.add(new Var("name", gr[i].getType()));
                    GraphRole[] groles = gr[i].getRoles();
                    for (int h = 0; h < groles.length; ++h) {
                        Repeat rroles = new Repeat("roles");
                        rroles.add(new Var("name", groles[h].getName()));
                        rroles.add(new Var("player", groles[h].getPlayer().getID()));
                        rels.add(rroles);
                    }
                    ens.add(rels);
                }
                r.add(ens);
            }
        }
    }

    private File copyResourceFromTo(String from, String to) throws FileNotFoundException, IOException {
        InputStream streamToModiaf = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(from);
        if (streamToModiaf == null) {
            throw new FileNotFoundException(from + " resource not found");
        }
        File destination = new File(to);
        if (destination.isDirectory() && !destination.exists()) {
            destination.mkdirs();
        }
        FileOutputStream target = new FileOutputStream(destination);
        byte[] bytes = new byte[8000];
        int read = 0;
        do {
            if ((read = streamToModiaf.read(bytes)) <= 0) continue;
            target.write(bytes, 0, read);
        } while (read != -1);
        target.close();
        streamToModiaf.close();
        return destination;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("INGENIAS HTML Document Generator  (C) 2012 Jorge Gomez");
        System.out.println("This program comes with ABSOLUTELY NO WARRANTY; for details check www.gnu.org/copyleft/gpl.html.");
        System.out.println("This is free software, and you are welcome to redistribute it under certain conditions;; for details check www.gnu.org/copyleft/gpl.html.");
        if (args.length == 0) {
            System.err.println("The first argument (mandatory) has to be the specification file and the second the outputfolder folder");
        } else {
            if (args.length >= 2) {
                Log.initInstance((PrintWriter)new PrintWriter(System.out));
                ModelJGraph.disableAllListeners();
                HTMLDocumentGenerator jadegen = new HTMLDocumentGenerator(args[0]);
                Properties props = jadegen.getBrowser().getState().prop;
                new File(args[1] + "/dochtml").mkdirs();
                jadegen.putProperty(new ProjectProperty("htmldoc", "htmldoc:output", "output", args[1] + "/dochtml", "htmldoc"));
                for (Object key : props.keySet()) {
                    System.err.println(((ProjectProperty)props.get((Object)key.toString())).key + ":" + ((ProjectProperty)props.get((Object)key.toString())).value);
                }
                jadegen.run();
            } else {
                System.err.println("The first argument (mandatory) has to be the specification file and the second  the outputfolder");
            }
            for (Frame f : Frame.getFrames()) {
                f.dispose();
            }
        }
    }
}

