/*
 * Decompiled with CFR 0.152.
 */
package ij_plugins.scala.console.editor;

import ij_plugins.scala.console.editor.Editor;
import ij_plugins.scala.console.editor.EditorCodeArea;
import ij_plugins.scala.console.editor.extra.Publisher;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scalafx.beans.Observable;
import scalafx.beans.binding.Bindings$;
import scalafx.beans.binding.BooleanBinding;
import scalafx.beans.property.ObjectProperty;
import scalafx.beans.property.ObjectProperty$;
import scalafx.beans.property.ReadOnlyObjectProperty;
import scalafx.beans.property.ReadOnlyObjectWrapper;
import scalafx.beans.property.ReadOnlyObjectWrapper$;
import scalafx.beans.value.ObservableValue;

public class EditorModel
implements Publisher<Editor.EditorEvent> {
    private Publisher self;
    private HashMap ij_plugins$scala$console$editor$extra$Publisher$$filters;
    private HashSet ij_plugins$scala$console$editor$extra$Publisher$$suspended;
    private final EditorCodeArea textArea;
    private final ReadOnlyObjectWrapper<Option<File>> _sourceFile;
    private final ReadOnlyObjectProperty sourceFile;
    private final ObjectProperty<Option<String>> lastSavedText;
    private final ObservableValue text;
    private final BooleanBinding needsSaving;

    public EditorModel(EditorCodeArea textArea) {
        this.textArea = textArea;
        Publisher.$init$(this);
        this._sourceFile = ReadOnlyObjectWrapper$.MODULE$.apply((Object)None$.MODULE$);
        this.sourceFile = this._sourceFile.readOnlyProperty();
        this.lastSavedText = ObjectProperty$.MODULE$.apply((Object)None$.MODULE$);
        this.text = textArea.text();
        this.needsSaving = Bindings$.MODULE$.createBooleanBinding((Function0 & Serializable)() -> {
            Option option = (Option)this.lastSavedText.value();
            if (option instanceof Some) {
                String lastText = (String)((Some)option).value();
                return !lastText.equals(textArea.text().value());
            }
            if (None$.MODULE$.equals(option)) {
                return !((String)textArea.text().value()).isEmpty();
            }
            throw new MatchError((Object)option);
        }, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Observable[]{this.lastSavedText, textArea.text()}));
        Statics.releaseFence();
    }

    @Override
    public Publisher self() {
        return this.self;
    }

    @Override
    public HashMap ij_plugins$scala$console$editor$extra$Publisher$$filters() {
        return this.ij_plugins$scala$console$editor$extra$Publisher$$filters;
    }

    @Override
    public HashSet ij_plugins$scala$console$editor$extra$Publisher$$suspended() {
        return this.ij_plugins$scala$console$editor$extra$Publisher$$suspended;
    }

    @Override
    public void ij_plugins$scala$console$editor$extra$Publisher$_setter_$self_$eq(Publisher x$0) {
        this.self = x$0;
    }

    @Override
    public void ij_plugins$scala$console$editor$extra$Publisher$_setter_$ij_plugins$scala$console$editor$extra$Publisher$$filters_$eq(HashMap x$0) {
        this.ij_plugins$scala$console$editor$extra$Publisher$$filters = x$0;
    }

    @Override
    public void ij_plugins$scala$console$editor$extra$Publisher$_setter_$ij_plugins$scala$console$editor$extra$Publisher$$suspended_$eq(HashSet x$0) {
        this.ij_plugins$scala$console$editor$extra$Publisher$$suspended = x$0;
    }

    private EditorCodeArea textArea() {
        return this.textArea;
    }

    public ReadOnlyObjectProperty<Option<File>> sourceFile() {
        return this.sourceFile;
    }

    public ObservableValue<String, String> text() {
        return this.text;
    }

    public String selection() {
        return this.textArea().selectedText();
    }

    public BooleanBinding needsSaving() {
        return this.needsSaving;
    }

    public void reset() {
        this.textArea().replaceText("");
        this._sourceFile.value_$eq((Object)None$.MODULE$);
        this.lastSavedText.value_$eq((Object)Some$.MODULE$.apply(this.textArea().text().value()));
    }

    public void read(File file) {
        BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        String lines = source.mkString();
        source.close();
        this.lastSavedText.value_$eq((Object)Some$.MODULE$.apply((Object)lines));
        this.textArea().replaceText(lines);
        this._sourceFile.value_$eq((Object)Some$.MODULE$.apply((Object)file));
    }

    public void save(File file) {
        try (FileWriter writer = new FileWriter(file);){
            String t = (String)this.text().value();
            writer.write(t);
            this.lastSavedText.value_$eq((Object)Some$.MODULE$.apply((Object)t));
        }
        this._sourceFile.value_$eq((Object)Some$.MODULE$.apply((Object)file));
    }
}

