/*
 * Decompiled with CFR 0.152.
 */
package ij_plugins.scala.console.editor;

import ij_plugins.scala.console.YesNoAlert$;
import ij_plugins.scala.console.editor.Action;
import ij_plugins.scala.console.editor.Action$;
import ij_plugins.scala.console.editor.EditorModel;
import java.io.File;
import java.io.Serializable;
import java.util.prefs.Preferences;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scalafx.Includes$;
import scalafx.scene.control.Alert;
import scalafx.scene.control.ButtonType;
import scalafx.scene.image.Image;
import scalafx.stage.FileChooser;
import scalafx.stage.FileChooser$;
import scalafx.stage.Window;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EditorController {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EditorController.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final Window ownerWindow;
    private final EditorModel model;
    public final String ij_plugins$scala$console$editor$EditorController$$defaultExtension;
    private FileChooser fileChooser$lzy1;
    private final Action fileNewAction;
    private final Action fileOpenAction;
    private final Action fileSaveAction;
    private final Action fileSaveAsAction;

    public EditorController(Window ownerWindow, EditorModel model) {
        this.ownerWindow = ownerWindow;
        this.model = model;
        this.ij_plugins$scala$console$editor$EditorController$$defaultExtension = "scala";
        this.fileNewAction = Action$.MODULE$.apply("New...", this.loadIcon("/ij_plugins/scala/console/resources/icons/page.png"), (EventHandler<ActionEvent>)Includes$.MODULE$.eventClosureWrapperWithZeroParam((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.ifModifiedAskAndSave()) {
                model.reset();
                return;
            }
        }));
        this.fileOpenAction = Action$.MODULE$.apply("Open...", this.loadIcon("/ij_plugins/scala/console/resources/icons/folder_page.png"), (EventHandler<ActionEvent>)Includes$.MODULE$.eventClosureWrapperWithZeroParam((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.ifModifiedAskAndSave()) {
                File file = this.fileChooser().showOpenDialog(ownerWindow);
                if (file != null) {
                    this.currentDirectory_$eq(file.getParentFile());
                    this.read(file);
                    return;
                }
                return;
            }
        }));
        this.fileSaveAction = Action$.MODULE$.apply("Save", this.loadIcon("/ij_plugins/scala/console/resources/icons/disk.png"), (EventHandler<ActionEvent>)Includes$.MODULE$.eventClosureWrapperWithZeroParam((Function0)(JFunction0.mcV.sp & Serializable)() -> this.save()));
        this.fileSaveAsAction = Action$.MODULE$.apply("Save As...", null, (EventHandler<ActionEvent>)Includes$.MODULE$.eventClosureWrapperWithZeroParam((Function0)(JFunction0.mcV.sp & Serializable)() -> this.saveAs()));
    }

    private Window ownerWindow() {
        return this.ownerWindow;
    }

    private EditorModel model() {
        return this.model;
    }

    private FileChooser fileChooser() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    FileChooser fileChooser;
                    this.fileChooser$lzy1 = fileChooser = new FileChooser(this){
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            super(FileChooser$.MODULE$.$lessinit$greater$default$1());
                            this.initialDirectory_$eq($outer.ij_plugins$scala$console$editor$EditorController$$currentDirectory());
                            Includes$.MODULE$.observableList2ObservableBuffer(this.extensionFilters()).$plus$eq((Object)FileChooser.ExtensionFilter$.MODULE$.sfxExtensionFilter2jfx(new FileChooser.ExtensionFilter(new StringBuilder(2).append("*.").append($outer.ij_plugins$scala$console$editor$EditorController$$defaultExtension).toString(), new StringBuilder(2).append("*.").append($outer.ij_plugins$scala$console$editor$EditorController$$defaultExtension).toString())));
                        }
                    };
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return fileChooser;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.fileChooser$lzy1;
    }

    private Image loadIcon(String url) {
        return new Image(url);
    }

    public Seq<Action> fileActions() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Action[]{this.fileNewAction, this.fileOpenAction, this.fileSaveAction, this.fileSaveAsAction}));
    }

    public void read(File file) {
        this.model().read(file);
    }

    private void save() {
        Option option = (Option)this.model().sourceFile().value();
        if (option instanceof Some) {
            File file = (File)((Some)option).value();
            this.model().save(file);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.saveAs();
            return;
        }
        throw new MatchError((Object)option);
    }

    private boolean saveAs() {
        File file = this.fileChooser().showSaveDialog(this.ownerWindow());
        if (file == null) {
            return false;
        }
        this.currentDirectory_$eq(file.getParentFile());
        this.model().save(this.ensureExtension(file, this.ij_plugins$scala$console$editor$EditorController$$defaultExtension));
        return true;
    }

    private File ensureExtension(File file, String extension) {
        if (file.getName().toLowerCase().endsWith(new StringBuilder(1).append(".").append(extension).toString())) {
            return file;
        }
        return new File(new StringBuilder(1).append(file.getPath()).append(".").append(extension).toString());
    }

    public File ij_plugins$scala$console$editor$EditorController$$currentDirectory() {
        File file;
        block3: {
            try {
                Preferences prefNode = Preferences.userRoot().node(this.getClass().getName());
                String currentDirectory = prefNode.get("fileChooser.currentDirectory", null);
                if (currentDirectory == null) {
                    file = null;
                    break block3;
                }
                file = new File(currentDirectory);
            }
            catch (Throwable throwable) {
                file = null;
            }
        }
        return file;
    }

    private void currentDirectory_$eq(File dir) {
        try {
            Preferences prefNode = Preferences.userRoot().node(this.getClass().getName());
            prefNode.put("fileChooser.currentDirectory", dir.getCanonicalPath());
        }
        catch (Throwable throwable) {}
    }

    public boolean prepareToClose() {
        return this.ifModifiedAskAndSave();
    }

    private boolean ifModifiedAskAndSave() {
        if (this.model().needsSaving().value()) {
            Alert alert = YesNoAlert$.MODULE$.apply(null, "New...", "Editor Content Modified.", "Do you want to save current script?");
            Option result = alert.showAndWait();
            Option option = result;
            if (option instanceof Some) {
                ButtonType buttonType = (ButtonType)((Some)option).value();
                ButtonType buttonType2 = YesNoAlert$.MODULE$.ButtonTypeYes();
                ButtonType buttonType3 = buttonType;
                if (!(buttonType2 != null ? !buttonType2.equals(buttonType3) : buttonType3 != null)) {
                    this.save();
                    return true;
                }
                ButtonType buttonType4 = YesNoAlert$.MODULE$.ButtonTypeNo();
                ButtonType buttonType5 = buttonType;
                if (!(buttonType4 != null ? !buttonType4.equals(buttonType5) : buttonType5 != null)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

