/*
 * Decompiled with CFR 0.152.
 */
package ij_plugins.scala.console.editor;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import scala.Function1;
import scala.Predef$;
import scala.compat.java8.FunctionConverters.package$;
import scala.runtime.Scala3RunTime$;
import scalafx.Includes$;
import scalafx.beans.value.ObservableValue;
import scalafx.delegate.SFXEnumDelegate;
import scalafx.scene.Parent;
import scalafx.scene.control.ScrollPane;

public class EditorCodeArea {
    private final Pattern ScalaPattern;
    public final CodeArea ij_plugins$scala$console$editor$EditorCodeArea$$codeArea;
    private final VirtualizedScrollPane<CodeArea> _view;
    private final ObservableValue text;

    public EditorCodeArea() {
        Object[] Keywords = new String[]{"abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "Null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "Try", "true", "type", "val", "Var", "while", "with", "yield", "-", ":", "=", "=>", "<-", "<:", "<%", ">:", "#", "@"};
        String KeywordPattern = new StringBuilder(6).append("\\b(").append(Predef$.MODULE$.wrapRefArray(Keywords).mkString("|")).append(")\\b").toString();
        String ParenPattern = "\\(|\\)";
        String BracePattern = "\\{|\\}";
        String BracketPattern = "\\[|\\]";
        String SemicolonPattern = "\\;";
        String StringPattern = "\"([^\"\\\\]|\\\\.)*\"";
        String CommentPattern = "//[^\n]*|/\\*(.|\\R)*?\\*/";
        this.ScalaPattern = Pattern.compile(new StringBuilder(87).append("(?<KEYWORD>").append(KeywordPattern).append(")").append("|(?<PAREN>").append(ParenPattern).append(")").append("|(?<BRACE>").append(BracePattern).append(")").append("|(?<BRACKET>").append(BracketPattern).append(")").append("|(?<SEMICOLON>").append(SemicolonPattern).append(")").append("|(?<STRING>").append(StringPattern).append(")").append("|(?<COMMENT>").append(CommentPattern).append(")").toString());
        this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea = new CodeArea();
        this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea));
        Includes$.MODULE$.jfxRegion2sfx((Region)this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea).stylesheets().$plus$eq((Object)this.getClass().getResource("scala-keywords.css").toExternalForm());
        Function1 & Serializable filterOp = (Function1 & Serializable)ch -> !ch.getInserted().equals(ch.getRemoved());
        this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea.richChanges().filter(package$.MODULE$.asJavaPredicate((Function1)filterOp)).subscribe((Consumer)new Consumer<RichTextChange<Collection<String>, String, Collection<String>>>(this){
            private final /* synthetic */ EditorCodeArea $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void accept(RichTextChange t) {
                this.$outer.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea.setStyleSpans(0, this.$outer.ij_plugins$scala$console$editor$EditorCodeArea$$computeHighlighting(this.$outer.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea.getText()));
            }
        });
        this._view = new VirtualizedScrollPane((Region)this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea, (ScrollPane.ScrollBarPolicy)ScrollPane.ScrollBarPolicy$.MODULE$.sfxEnum2jfx((SFXEnumDelegate)ScrollPane.ScrollBarPolicy$.AsNeeded$.MODULE$), (ScrollPane.ScrollBarPolicy)ScrollPane.ScrollBarPolicy$.MODULE$.sfxEnum2jfx((SFXEnumDelegate)ScrollPane.ScrollBarPolicy$.Always$.MODULE$));
        this.text = Includes$.MODULE$.jfxObservableValue2sfx(this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea.textProperty());
    }

    public Parent view() {
        return Includes$.MODULE$.jfxRegion2sfx(this._view);
    }

    public ObservableValue<String, String> text() {
        return this.text;
    }

    public void replaceText(String text) {
        this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea.replaceText(text);
    }

    public String selectedText() {
        return this.ij_plugins$scala$console$editor$EditorCodeArea$$codeArea.getSelectedText();
    }

    public StyleSpans<Collection<String>> ij_plugins$scala$console$editor$EditorCodeArea$$computeHighlighting(String text) {
        Matcher matcher = this.ScalaPattern.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            String styleClass;
            String string = matcher.group("KEYWORD") != null ? "keyword" : (matcher.group("PAREN") != null ? "paren" : (matcher.group("BRACE") != null ? "brace" : (matcher.group("BRACKET") != null ? "bracket" : (matcher.group("SEMICOLON") != null ? "semicolon" : (matcher.group("STRING") != null ? "string" : (styleClass = matcher.group("COMMENT") != null ? "comment" : null))))));
            if (styleClass == null) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }
}

