/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;

public final class TemporaryDirectory {
    private File m_directory;

    public final File getDirectory() throws IOException {
        if (this.m_directory == null) {
            this.m_directory = File.createTempFile(this.getClass().getName(), "test");
            Assert.assertTrue((boolean)this.m_directory.delete());
            Assert.assertTrue((boolean)this.m_directory.mkdir());
            this.m_directory.deleteOnExit();
        }
        return this.m_directory;
    }

    public void delete() throws Exception {
        if (this.m_directory != null) {
            TemporaryDirectory.delete(this.m_directory);
            this.m_directory = null;
        }
    }

    public final File newFile(String filename) throws IOException {
        return new File(this.getDirectory(), "logs");
    }

    private static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children == null) {
                System.err.println("Could not list directory '" + f + "'");
            } else {
                for (int i = 0; i < children.length; ++i) {
                    TemporaryDirectory.delete(children[i]);
                }
            }
        }
        if (!f.delete()) {
            System.err.println("Could not delete file '" + f + "'");
        }
    }
}

