/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class StubTimer
extends Timer {
    private final Map<Long, TimerTask> m_taskByPeriod = new HashMap<Long, TimerTask>();
    private TimerTask m_lastScheduledTimerTask;
    private long m_lastDelay;
    private long m_lastPeriod;

    public StubTimer() {
        super(false);
    }

    @Override
    public void schedule(TimerTask timerTask, long delay, long period) {
        this.m_lastScheduledTimerTask = timerTask;
        this.m_lastDelay = delay;
        this.m_lastPeriod = period;
        this.m_taskByPeriod.put(new Long(period), timerTask);
    }

    @Override
    public void schedule(TimerTask timerTask, long delay) {
        this.m_lastScheduledTimerTask = timerTask;
        this.m_lastDelay = delay;
        this.m_lastPeriod = 0L;
    }

    public TimerTask getLastScheduledTimerTask() {
        return this.m_lastScheduledTimerTask;
    }

    public long getLastDelay() {
        return this.m_lastDelay;
    }

    public long getLastPeriod() {
        return this.m_lastPeriod;
    }

    public TimerTask getTaskByPeriod(long period) {
        return this.m_taskByPeriod.get(new Long(period));
    }
}

