/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.grinder.testutility.StreamCopier;
import org.junit.Assert;

public class FileUtilities {
    private static Random s_random = new Random();

    public static void setCanAccess(File file, boolean canAccess) throws Exception {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String path = file.getCanonicalPath();
            path = path.replaceAll("%20", " ");
            FileUtilities.exec(new String[]{"cacls", path, "/E", "/P", System.getProperty("user.name") + ":" + (canAccess ? "F" : "N")});
        } else {
            FileUtilities.exec(new String[]{"chmod", canAccess ? "ugo+rwx" : "ugo-rwx", file.getCanonicalPath()});
        }
    }

    private static void exec(String[] command) throws InterruptedException {
        Process process;
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't chmod: perhaps you should patch thistest for your platform?", e){};
        }
        process.waitFor();
        Assert.assertEquals((String)("exec of " + Arrays.asList(command) + " succeeded"), (long)0L, (long)process.exitValue());
    }

    public static String readLastLine(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String last = null;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    String string = last;
                    return string;
                }
                last = line;
            }
        }
        finally {
            reader.close();
        }
    }

    public static int countLines(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            int result = 0;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    int n = result;
                    return n;
                }
                ++result;
            }
        }
        finally {
            reader.close();
        }
    }

    public static void createRandomFile(File file) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        byte[] bytes = new byte[s_random.nextInt(2000)];
        s_random.nextBytes(bytes);
        ((OutputStream)out).write(bytes);
        ((OutputStream)out).close();
    }

    public static String fileContents(File file) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        new StreamCopier().copy(new FileInputStream(file), byteOutputStream);
        return new String(byteOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(File file, List<String> lines) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        PrintWriter out = new PrintWriter(new FileWriter(file));
        try {
            for (String line : lines) {
                out.println(line);
            }
        }
        finally {
            out.close();
        }
    }

    public static void createFile(File file, String ... lines) throws IOException {
        FileUtilities.createFile(file, Arrays.asList(lines));
    }
}

