/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.grinder.testutility.AbstractStubFactory;

public final class DelegatingStubFactory<T>
extends AbstractStubFactory<T> {
    public static <T> DelegatingStubFactory<T> create(T delegate) {
        return new DelegatingStubFactory<T>(delegate);
    }

    private DelegatingStubFactory(T delegate) {
        super(DelegatingStubFactory.getClass(delegate), new DelegatingInvocationHandler<T>(delegate));
    }

    private static final class DelegatingInvocationHandler<T>
    implements InvocationHandler {
        private final T m_delegate;

        public DelegatingInvocationHandler(T delegate) {
            this.m_delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
            Method delegateMethod = this.m_delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            return delegateMethod.invoke(this.m_delegate, parameters);
        }
    }
}

