/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import net.grinder.testutility.CallAssertions;
import net.grinder.testutility.CallData;

public class CallRecorder
extends Assert
implements CallAssertions {
    private static ThreadRecording s_threadRecording = new ThreadRecording();
    private final LinkedList<CallData> m_callDataList = new LinkedList();
    private List<MethodFilter> m_methodFilters = new ArrayList<MethodFilter>();
    private boolean m_ignoreCallOrder = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetCallHistory() {
        LinkedList<CallData> linkedList = this.m_callDataList;
        synchronized (linkedList) {
            this.m_callDataList.clear();
            this.m_callDataList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCalled(int timeout) {
        long expires = System.currentTimeMillis() + (long)timeout;
        LinkedList<CallData> linkedList = this.m_callDataList;
        synchronized (linkedList) {
            while (this.m_callDataList.size() == 0) {
                try {
                    this.m_callDataList.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (System.currentTimeMillis() <= expires) continue;
                CallRecorder.fail((String)("Timed out waiting to be called after " + timeout + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCallHistory() {
        StringBuffer result = new StringBuffer();
        try {
            s_threadRecording.disable();
            LinkedList<CallData> linkedList = this.m_callDataList;
            synchronized (linkedList) {
                for (CallData callData : this.m_callDataList) {
                    result.append(callData);
                    result.append("\n");
                }
            }
        }
        finally {
            s_threadRecording.enable();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallData peekFirst() {
        LinkedList<CallData> linkedList = this.m_callDataList;
        synchronized (linkedList) {
            if (this.m_callDataList.size() > 0) {
                return this.m_callDataList.getFirst();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertNoMoreCalls() {
        LinkedList<CallData> linkedList = this.m_callDataList;
        synchronized (linkedList) {
            CallRecorder.assertEquals((String)("Call history:\n" + this.getCallHistory()), (int)0, (int)this.m_callDataList.size());
        }
    }

    public void setIgnoreCallOrder(boolean b) {
        this.m_ignoreCallOrder = b;
    }

    public void setIgnoreObjectMethods() {
        this.m_methodFilters.add(new MethodFilter(){

            @Override
            public boolean matches(Method m) {
                return m.getDeclaringClass() == Object.class;
            }
        });
    }

    public void setIgnoreMethod(final String methodName) {
        this.m_methodFilters.add(new MethodFilter(){

            @Override
            public boolean matches(Method m) {
                return m.getName().equals(methodName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void record(CallData callData) {
        if (s_threadRecording.isEnabled()) {
            for (MethodFilter filter : this.m_methodFilters) {
                if (!filter.matches(callData.getMethod())) continue;
                return;
            }
            LinkedList<CallData> linkedList = this.m_callDataList;
            synchronized (linkedList) {
                this.m_callDataList.add(callData);
                this.m_callDataList.notifyAll();
            }
        }
    }

    @Override
    public final CallData assertSuccess(final String methodName, final Object ... parameters) {
        return new AssertMatchingCallTemplate(){

            @Override
            public void test(CallData callData) {
                callData.assertSuccess(methodName, parameters);
            }
        }.run();
    }

    @Override
    public final CallData assertSuccess(final String methodName, final Class<?> ... parameterTypes) {
        return new AssertMatchingCallTemplate(){

            @Override
            public void test(CallData callData) {
                callData.assertSuccess(methodName, parameterTypes);
            }
        }.run();
    }

    @Override
    public final CallData assertException(final String methodName, final Throwable throwable, final Object ... parameters) {
        return new AssertMatchingCallTemplate(){

            @Override
            public void test(CallData callData) {
                callData.assertException(methodName, throwable, parameters);
            }
        }.run();
    }

    @Override
    public final CallData assertException(final String methodName, final Throwable throwable, final Class<?> ... parameterTypes) {
        return new AssertMatchingCallTemplate(){

            @Override
            public void test(CallData callData) {
                callData.assertException(methodName, throwable, parameterTypes);
            }
        }.run();
    }

    @Override
    public final CallData assertException(final String methodName, final Class<?> throwableType, final Object ... parameters) {
        return new AssertMatchingCallTemplate(){

            @Override
            public void test(CallData callData) {
                callData.assertException(methodName, throwableType, parameters);
            }
        }.run();
    }

    @Override
    public final CallData assertException(final String methodName, final Class<?> throwableType, final Class<?> ... parameterTypes) {
        return new AssertMatchingCallTemplate(){

            @Override
            public void test(CallData callData) {
                callData.assertException(methodName, throwableType, parameterTypes);
            }
        }.run();
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    private static final class ThreadRecording {
        private final ThreadLocal<ThreadRecording> m_threadLocal = new ThreadLocal();

        private ThreadRecording() {
        }

        public void disable() {
            this.m_threadLocal.set(this);
        }

        public void enable() {
            this.m_threadLocal.set(null);
        }

        public boolean isEnabled() {
            return this.m_threadLocal.get() == null;
        }
    }

    private abstract class AssertMatchingCallTemplate {
        private AssertMatchingCallTemplate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final CallData run() {
            Iterator iterator;
            block18: {
                s_threadRecording.disable();
                if (CallRecorder.this.m_ignoreCallOrder) {
                    LinkedList linkedList = CallRecorder.this.m_callDataList;
                    // MONITORENTER : linkedList
                    iterator = CallRecorder.this.m_callDataList.iterator();
                    break block18;
                } else {
                    LinkedList linkedList = CallRecorder.this.m_callDataList;
                    // MONITORENTER : linkedList
                    try {
                        CallData callData = (CallData)CallRecorder.this.m_callDataList.removeFirst();
                        CallRecorder.this.m_callDataList.notifyAll();
                        this.test(callData);
                        CallData callData2 = callData;
                        // MONITOREXIT : linkedList
                        return callData2;
                    }
                    catch (NoSuchElementException e) {
                        Assert.fail((String)"No more calls");
                        CallData callData = null;
                        // MONITOREXIT : linkedList
                        s_threadRecording.enable();
                        return callData;
                    }
                }
                finally {
                    s_threadRecording.enable();
                }
            }
            while (iterator.hasNext()) {
                try {
                    CallData callData = (CallData)iterator.next();
                    this.test(callData);
                    iterator.remove();
                    CallRecorder.this.m_callDataList.notifyAll();
                    CallData callData3 = callData;
                    // MONITOREXIT : linkedList
                    return callData3;
                }
                catch (AssertionFailedError assertionFailedError) {
                }
            }
            // MONITOREXIT : linkedList
            Assert.fail((String)"No matching call");
            return null;
        }

        public abstract void test(CallData var1);
    }
}

