/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

public class AssertUtilities
extends Assert {
    public static void assertArraysEqual(Object[] a, Object[] b) {
        AssertUtilities.assertArraysEqual("", a, b);
    }

    public static void assertArraysEqual(String message, Object[] a, Object[] b) {
        if (!message.equals("")) {
            message = message + ": ";
        }
        if (a != null || b != null) {
            AssertUtilities.assertNotNull((String)(message + "first is not null"), (Object)a);
            AssertUtilities.assertNotNull((String)(message + "second is not null"), (Object)b);
            if (a != null && b != null) {
                AssertUtilities.assertEquals((String)(message + "arrays of equal length"), (int)a.length, (int)b.length);
                for (int i = 0; i < a.length; ++i) {
                    AssertUtilities.assertEquals((String)(message + "element " + i + " equal"), (Object)a[i], (Object)b[i]);
                }
            }
        }
    }

    public static void assertArraysEqual(byte[] a, byte[] b) {
        AssertUtilities.assertArraysEqual("", a, b);
    }

    public static void assertArraysEqual(String message, byte[] a, byte[] b) {
        if (!message.equals("")) {
            message = message + ": ";
        }
        if (a != null || b != null) {
            AssertUtilities.assertNotNull((String)(message + "first is not null"), (Object)a);
            AssertUtilities.assertNotNull((String)(message + "second is not null"), (Object)b);
            if (a != null && b != null) {
                AssertUtilities.assertEquals((String)(message + "arrays of equal length"), (int)a.length, (int)b.length);
                for (int i = 0; i < a.length; ++i) {
                    AssertUtilities.assertEquals((String)(message + "element " + i + " equal"), (byte)a[i], (byte)b[i]);
                }
            }
        }
    }

    public static void assertArrayContainsAll(Object[] array1, Object[] array2) {
        List<Object> list1 = Arrays.asList(array1);
        List<Object> list2 = Arrays.asList(array2);
        AssertUtilities.assertTrue((String)("" + list1 + " contains " + list2), (boolean)new HashSet<Object>(list1).containsAll(list2));
    }

    public static void assertNotEquals(Object o1, Object o2) {
        if (o1 == null) {
            AssertUtilities.assertNotNull((Object)o2);
        } else {
            AssertUtilities.assertTrue((String)("'" + o1 + "' is not equal to '" + o2 + "'"), (!o1.equals(o2) ? 1 : 0) != 0);
        }
    }

    public static void assertStartsWith(String text, String value) {
        AssertUtilities.assertTrue((String)("'" + text + "' starts with '" + value + "'"), (text != null && text.indexOf(value) == 0 ? 1 : 0) != 0);
    }

    public static void assertContains(String text, String value) {
        AssertUtilities.assertTrue((String)("'" + text + "' contains '" + value + "'"), (text != null && text.indexOf(value) >= 0 ? 1 : 0) != 0);
    }

    public static void assertEndsWith(String text, String value) {
        AssertUtilities.assertEquals((String)("'" + text + "' ends with '" + value + "'"), (int)(text.length() - value.length()), (int)text.lastIndexOf(value));
    }

    public static void assertContainsHeader(String text, String key, String value) {
        Pattern headerPattern = Pattern.compile(key + ":[ \t]*" + value + "\r\n");
        Matcher matcher = headerPattern.matcher(text);
        AssertUtilities.assertTrue((String)("'" + text + "' contains header '" + key + "' with value '" + value + "'"), (boolean)matcher.find());
    }

    public static void assertContainsPattern(String text, String pattern) {
        Matcher matcher = Pattern.compile(pattern).matcher(text);
        AssertUtilities.assertTrue((String)("'" + text + "' contains pattern '" + pattern + "'"), (boolean)matcher.find());
    }
}

