/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.After;

public abstract class AbstractFileTestCase
extends TestCase {
    protected static Random s_random = new Random();
    private File m_directory;

    @After
    public void tearDown() throws Exception {
        if (this.m_directory != null) {
            AbstractFileTestCase.delete(this.m_directory);
        }
    }

    private static void delete(File f) throws Exception {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children == null) {
                System.err.println("Could not list directory '" + f + "'");
            } else {
                for (int i = 0; i < children.length; ++i) {
                    AbstractFileTestCase.delete(children[i]);
                }
            }
        }
        if (!f.delete()) {
            System.err.println("Could not delete file '" + f + "'");
        }
    }

    protected final File getDirectory() throws IOException {
        if (this.m_directory == null) {
            this.m_directory = File.createTempFile(((Object)((Object)this)).getClass().getName(), "test");
            AbstractFileTestCase.assertTrue((boolean)this.m_directory.delete());
            AbstractFileTestCase.assertTrue((boolean)this.m_directory.mkdir());
            this.m_directory.deleteOnExit();
        }
        return this.m_directory;
    }
}

