/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.grinder.testutility.RandomStubFactory;

public final class StubRelationshipsInvocationHandlerDecorator
implements InvocationHandler {
    private Map<String, Object> m_stubs = new HashMap<String, Object>();
    private final InvocationHandler m_delegate;

    public StubRelationshipsInvocationHandlerDecorator(InvocationHandler delegate) {
        this.m_delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        if (parameters == null || parameters.length == 0 && methodName.indexOf("get") == 0 && !returnType.equals(Void.TYPE)) {
            Object existingStub = this.m_stubs.get(methodName);
            if (existingStub != null) {
                return existingStub;
            }
            RandomStubFactory<?> stubFactory = RandomStubFactory.create(returnType);
            this.m_stubs.put(methodName, stubFactory.getStub());
            return stubFactory.getStub();
        }
        return this.m_delegate.invoke(proxy, method, parameters);
    }
}

