/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assert;

public abstract class RedirectStandardStreams {
    private final ByteArrayOutputStream m_stdoutContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream m_stderrContent = new ByteArrayOutputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RedirectStandardStreams run() throws Exception {
        PrintStream oldStdout = System.out;
        PrintStream oldStderr = System.err;
        System.setOut(new PrintStream(this.m_stdoutContent));
        System.setErr(new PrintStream(this.m_stderrContent));
        try {
            this.runWithRedirectedStreams();
        }
        finally {
            System.setOut(oldStdout);
            System.setErr(oldStderr);
        }
        return this;
    }

    public final RedirectStandardStreams assertNoStdout() {
        byte[] bytes = this.getStdoutBytes();
        Assert.assertTrue((String)("stdout = " + new String(bytes)), (bytes.length == 0 ? 1 : 0) != 0);
        return this;
    }

    public final RedirectStandardStreams assertNoStderr() {
        byte[] bytes = this.getStderrBytes();
        Assert.assertTrue((String)("stderr = " + new String(bytes)), (bytes.length == 0 ? 1 : 0) != 0);
        return this;
    }

    public final byte[] getStdoutBytes() {
        return this.m_stdoutContent.toByteArray();
    }

    public final byte[] getStderrBytes() {
        return this.m_stderrContent.toByteArray();
    }

    protected abstract void runWithRedirectedStreams() throws Exception;

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("RedirectStandardStreams");
        result.append("\nstdout:\n");
        result.append(new String(this.m_stdoutContent.toByteArray()));
        result.append("\nstderr:\n");
        result.append(new String(this.m_stderrContent.toByteArray()));
        return result.toString();
    }
}

