/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.grinder.testutility.AbstractStubFactory;
import net.grinder.testutility.OverrideInvocationHandlerDecorator;
import net.grinder.testutility.SimpleEqualityDecoration;

public final class RandomObjectFactory {
    private final Random m_random = new Random();

    public Object generateParameter(Class<?> type) {
        if (Boolean.TYPE == type || Boolean.class == type) {
            return this.m_random.nextBoolean();
        }
        if (Character.TYPE == type || Character.class == type) {
            return new Character((char)this.m_random.nextInt());
        }
        if (Byte.TYPE == type || Byte.class == type) {
            return new Byte((byte)this.m_random.nextInt(256));
        }
        if (Short.TYPE == type || Short.class == type) {
            return new Short((short)this.m_random.nextInt(65536));
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return new Integer(this.m_random.nextInt());
        }
        if (Long.TYPE == type || Long.class == type) {
            return new Long(this.m_random.nextLong());
        }
        if (Float.TYPE == type || Float.class == type) {
            return new Float(this.m_random.nextFloat());
        }
        if (Double.TYPE == type || Double.class == type) {
            return new Double(this.m_random.nextDouble());
        }
        if (Void.TYPE == type) {
            return null;
        }
        if (String.class == type) {
            byte[] bytes = new byte[Math.abs(this.m_random.nextInt() % 50)];
            this.m_random.nextBytes(bytes);
            return new String(bytes);
        }
        if (Map.class == type) {
            int size = Math.abs(this.m_random.nextInt() % 10);
            HashMap<Object, Object> result = new HashMap<Object, Object>(size);
            for (int i = 0; i < size; ++i) {
                result.put(this.generateParameter(String.class), this.generateParameter(String.class));
            }
            return result;
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (Byte.TYPE == componentType) {
                return new byte[Math.abs(this.m_random.nextInt() % 1000)];
            }
            int size = Math.abs(this.m_random.nextInt() % 10);
            Object result = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Object o = this.generateParameter(componentType);
                Array.set(result, i, o);
            }
            return result;
        }
        if (Exception.class == type) {
            return new Exception((String)this.generateParameter(String.class));
        }
        if (Throwable.class == type) {
            return new Throwable((String)this.generateParameter(String.class));
        }
        return Proxy.newProxyInstance(type.getClassLoader(), AbstractStubFactory.getAllInterfaces(type), (InvocationHandler)new OverrideInvocationHandlerDecorator(new NullInvocationHandler(), new SimpleEqualityDecoration("a null " + type.getName())));
    }

    public Object[] generateParameters(Class<?>[] parameterTypes) {
        if (parameterTypes.length == 0) {
            return null;
        }
        Object[] parameters = new Object[parameterTypes.length];
        for (int j = 0; j < parameters.length; ++j) {
            parameters[j] = this.generateParameter(parameterTypes[j]);
        }
        return parameters;
    }

    public static class NullInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
            return null;
        }
    }
}

