/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public final class OverrideInvocationHandlerDecorator
implements InvocationHandler {
    private final InvocationHandler m_delegate;
    private final Object m_overrider;
    private final String m_overridePrefix;

    public OverrideInvocationHandlerDecorator(InvocationHandler delegate, Object overrider) {
        this(delegate, overrider, "override_");
    }

    public OverrideInvocationHandlerDecorator(InvocationHandler delegate, Object overrider, String overridePrefix) {
        this.m_delegate = delegate;
        this.m_overrider = overrider;
        this.m_overridePrefix = overridePrefix;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        Method overriddenMethod = this.getOverriddenMethod(method);
        if (overriddenMethod != null) {
            Object[] proxyAndParameters;
            if (parameters != null) {
                proxyAndParameters = new Object[parameters.length + 1];
                proxyAndParameters[0] = proxy;
                System.arraycopy(parameters, 0, proxyAndParameters, 1, parameters.length);
            } else {
                proxyAndParameters = new Object[]{proxy};
            }
            return overriddenMethod.invoke(this.m_overrider, proxyAndParameters);
        }
        return this.m_delegate.invoke(proxy, method, parameters);
    }

    private Method getOverriddenMethod(Method method) {
        try {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            Class[] parameterTypes = new Class[methodParameterTypes.length + 1];
            parameterTypes[0] = Object.class;
            System.arraycopy(methodParameterTypes, 0, parameterTypes, 1, methodParameterTypes.length);
            Method candidate = this.m_overrider.getClass().getMethod(this.m_overridePrefix + method.getName(), parameterTypes);
            if (candidate.getReturnType().equals(method.getReturnType())) {
                return candidate;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

