/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.util.Collection;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;

public class MockingUtilities {
    public static <T extends Collection<?>> T equalContents(final T t) {
        return (T)((Collection)Matchers.argThat((Matcher)new TypedArgumentMatcher<T>(){

            @Override
            protected boolean argumentMatches(T actual) {
                return actual != null && actual.containsAll(t) && t.containsAll((Collection<?>)actual);
            }

            public void describeTo(Description description) {
                description.appendText("equalContents(" + t + ")");
            }
        }));
    }

    public static <T> Class<T> subclass(final Class<T> superClass) {
        return (Class)Matchers.argThat((Matcher)new TypedArgumentMatcher<Class<T>>(){

            @Override
            protected boolean argumentMatches(Class<T> t) {
                return superClass.isAssignableFrom(t);
            }

            public void describeTo(Description description) {
                description.appendText("subclass(" + superClass.getName() + ")");
            }
        });
    }

    public static String containsRegex(final String regex) {
        return (String)Matchers.argThat((Matcher)new TypedArgumentMatcher<String>(){

            @Override
            protected boolean argumentMatches(String text) {
                return Pattern.compile(regex).matcher(text).find();
            }

            public void describeTo(Description description) {
                description.appendText("containsRegex(\"" + regex.replaceAll("\\\\", "\\\\\\\\") + "\")");
            }
        });
    }

    public static abstract class TypedArgumentMatcher<T>
    extends ArgumentMatcher<T> {
        public final boolean matches(Object argument) {
            try {
                return this.argumentMatches(argument);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        protected abstract boolean argumentMatches(T var1);
    }
}

