/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.grinder.testutility.StreamCopier;

public class IsolatedObjectFactory {
    public static Class<?> getIsolatedObjectClass() {
        try {
            return new SimpleObjectClassLoader().loadClass("SimpleObject");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Object getIsolatedObject() {
        try {
            return IsolatedObjectFactory.getIsolatedObjectClass().newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class SimpleObjectClassLoader
    extends ClassLoader {
        private SimpleObjectClassLoader() {
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.equals("SimpleObject")) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    InputStream resource = this.getParent().getResourceAsStream(this.getClass().getPackage().getName().replace('.', '/') + "/resources/SimpleObject.clazz");
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    try {
                        new StreamCopier().copy(resource, byteStream);
                        byte[] bytes = byteStream.toByteArray();
                        return this.defineClass(name, bytes, 0, bytes.length);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

