/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CountingInputStream
extends FilterInputStream {
    private int m_calls;
    private long m_bytes;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    private int add(int i) {
        if (i > 0) {
            this.m_bytes += (long)i;
        }
        ++this.m_calls;
        return i;
    }

    @Override
    public int read() throws IOException {
        return this.add(super.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.add(super.read(b, 0, b.length));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.add(super.read(b, off, len));
    }

    public long getCount() {
        return this.m_bytes;
    }

    public int getCalls() {
        return this.m_calls;
    }

    public String toString() {
        return "CountingInputStream: " + this.m_calls + " calls, " + this.m_bytes + " bytes";
    }
}

