/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.Assert;
import net.grinder.testutility.AssertUtilities;
import net.grinder.testutility.CallAssertions;

public final class CallData
extends Assert
implements CallAssertions {
    private final Method m_method;
    private final Object[] m_parameters;
    private final Object m_result;
    private final Throwable m_throwable;

    public CallData(Method method, Object result, Object ... parameters) {
        this.m_method = method;
        this.m_parameters = parameters;
        this.m_result = result;
        this.m_throwable = null;
    }

    public CallData(Method method, Throwable throwable, Object ... parameters) {
        this.m_method = method;
        this.m_parameters = parameters;
        this.m_result = null;
        this.m_throwable = throwable;
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String getMethodName() {
        return this.getMethod().getName();
    }

    public Object[] getParameters() {
        return this.m_parameters;
    }

    public Class<?>[] getParameterTypes() {
        if (this.m_parameters == null) {
            return new Class[0];
        }
        Class[] types = new Class[this.m_parameters.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.m_parameters[i] == null ? ANY_TYPE.class : this.m_parameters[i].getClass();
        }
        return types;
    }

    public Object getResult() {
        CallData.assertNull((Object)this.m_throwable);
        return this.m_result;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    @Override
    public final CallData assertSuccess(String methodName, Object ... parameters) {
        this.assertCalled(methodName, parameters);
        CallData.assertNull((Object)this.getThrowable());
        return this;
    }

    @Override
    public final CallData assertSuccess(String methodName, Class<?> ... parameterTypes) {
        this.assertCalled(methodName, parameterTypes);
        CallData.assertNull((Object)this.getThrowable());
        return this;
    }

    public final CallData assertSuccess(String methodName) {
        return this.assertSuccess(methodName, new Class[0]);
    }

    @Override
    public final CallData assertException(String methodName, Throwable throwable, Object ... parameters) {
        this.assertCalled(methodName, parameters);
        CallData.assertEquals((Object)throwable, (Object)this.getThrowable());
        return this;
    }

    @Override
    public final CallData assertException(String methodName, Throwable throwable, Class<?> ... parameterTypes) {
        this.assertCalled(methodName, parameterTypes);
        CallData.assertEquals((Object)throwable, (Object)this.getThrowable());
        return this;
    }

    @Override
    public final CallData assertException(String methodName, Class<?> throwableType, Object ... parameters) {
        this.assertCalled(methodName, parameters);
        CallData.assertTrue((boolean)throwableType.isAssignableFrom(this.getThrowable().getClass()));
        return this;
    }

    @Override
    public final CallData assertException(String methodName, Class<?> throwableType, Class<?> ... parameterTypes) {
        this.assertCalled(methodName, parameterTypes);
        CallData.assertNotNull((Object)this.getThrowable());
        CallData.assertTrue((boolean)throwableType.isAssignableFrom(this.getThrowable().getClass()));
        return this;
    }

    private void assertCalled(String methodName, Object ... parameters) {
        if (parameters.length == 0) {
            parameters = null;
        }
        CallData.assertEquals((String)methodName, (String)this.getMethodName());
        AssertUtilities.assertArraysEqual("Expected " + CallData.parametersToString(parameters) + " but was " + CallData.parametersToString(this.getParameters()), parameters, this.getParameters());
    }

    private void assertCalled(String methodName, Class<?> ... parameterTypes) {
        CallData.assertEquals((String)methodName, (String)this.getMethodName());
        Class<?>[] actualParameterTypes = this.getParameterTypes();
        if (parameterTypes != null || actualParameterTypes != null) {
            CallData.assertNotNull(parameterTypes);
            CallData.assertNotNull(actualParameterTypes);
            if (parameterTypes != null && actualParameterTypes != null) {
                CallData.assertEquals((String)"Called with the correct number of parameters", (int)parameterTypes.length, (int)actualParameterTypes.length);
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (actualParameterTypes[i].equals(ANY_TYPE.class)) continue;
                    CallData.assertTrue((String)("Parameter  " + i + " is instance of  " + actualParameterTypes[i].getName() + " which supports the interfaces " + Arrays.asList(actualParameterTypes[i].getInterfaces()) + " and is not assignable from " + parameterTypes[i].getName()), (boolean)parameterTypes[i].isAssignableFrom(actualParameterTypes[i]));
                }
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getMethodName());
        result.append(CallData.parametersToString(this.getParameters()));
        Throwable throwable = this.getThrowable();
        if (throwable != null) {
            result.append(" threw " + throwable);
        } else {
            result.append(" returned " + this.getResult());
        }
        return result.toString();
    }

    private static final String parametersToString(Object[] parameters) {
        StringBuffer result = new StringBuffer();
        result.append('(');
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                if (parameters[i] != null && !parameters[i].getClass().isPrimitive() && !parameters[i].getClass().isArray()) {
                    result.append("\"");
                    result.append(parameters[i]);
                    result.append("\"");
                    continue;
                }
                result.append(parameters[i]);
            }
        }
        result.append(')');
        return result.toString();
    }

    public static class ANY_TYPE {
    }
}

