/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.testutility;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.grinder.testutility.CallData;
import net.grinder.testutility.CallRecorder;
import net.grinder.testutility.OverrideInvocationHandlerDecorator;

public abstract class AbstractStubFactory<T>
extends CallRecorder {
    private static final WeakIdentityMap<Object, AbstractStubFactory<Object>> s_stubToFactory = new WeakIdentityMap();
    private final T m_stub;
    private final Map<String, Object> m_resultMap = new HashMap<String, Object>();
    private final Map<String, Throwable> m_throwsMap = new HashMap<String, Throwable>();

    public AbstractStubFactory(Class<T> stubbedInterface, InvocationHandler invocationHandler) {
        RecordingInvocationHandler decoratedInvocationHandler = new RecordingInvocationHandler(new StubResultInvocationHandler(new OverrideInvocationHandlerDecorator(invocationHandler, this)));
        this.m_stub = Proxy.newProxyInstance(stubbedInterface.getClassLoader(), AbstractStubFactory.getAllInterfaces(stubbedInterface), (InvocationHandler)decoratedInvocationHandler);
        s_stubToFactory.put(this.m_stub, this);
    }

    public final T getStub() {
        return this.m_stub;
    }

    public final void setResult(String methodName, Object result) {
        this.m_resultMap.put(methodName, result);
    }

    public final void setThrows(String methodName, Throwable result) {
        this.m_throwsMap.put(methodName, result);
    }

    public static Class<?>[] getAllInterfaces(Class<?> c) {
        HashSet interfaces = new HashSet();
        if (c.isInterface()) {
            interfaces.add(c);
        }
        do {
            Class<?>[] moreInterfaces;
            if ((moreInterfaces = c.getInterfaces()) == null) continue;
            interfaces.addAll(Arrays.asList(moreInterfaces));
        } while ((c = c.getSuperclass()) != null);
        return interfaces.toArray(new Class[0]);
    }

    public static AbstractStubFactory<?> getFactory(Object stub) {
        return s_stubToFactory.get(stub);
    }

    protected static <K> Class<K> getClass(K o) {
        return o.getClass();
    }

    private static class WeakIdentityMap<K, V> {
        private final ReferenceQueue<K> m_referenceQueue = new ReferenceQueue();
        private final Map<WeakIdKey, V> m_hashmap = new HashMap<WeakIdKey, V>();

        private WeakIdentityMap() {
        }

        private void cleanup() {
            Reference<K> k;
            while ((k = this.m_referenceQueue.poll()) != null) {
                this.m_hashmap.remove(k);
            }
        }

        public void put(K key, V value) {
            this.cleanup();
            this.m_hashmap.put(new WeakIdKey(key), value);
        }

        public V get(K key) {
            this.cleanup();
            return this.m_hashmap.get(new WeakIdKey(key));
        }

        private class WeakIdKey
        extends WeakReference<K> {
            private final int m_hashcode;

            WeakIdKey(K key) {
                super(key, WeakIdentityMap.this.m_referenceQueue);
                this.m_hashcode = System.identityHashCode(key);
            }

            public int hashCode() {
                return this.m_hashcode;
            }

            public boolean equals(Object other) {
                Object object = this.get();
                if (object != null) {
                    return object == ((WeakIdKey)other).get();
                }
                return this == other;
            }
        }
    }

    private final class StubResultInvocationHandler
    implements InvocationHandler {
        private final InvocationHandler m_delegate;

        public StubResultInvocationHandler(InvocationHandler delegate) {
            this.m_delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
            String methodName = method.getName();
            if (AbstractStubFactory.this.m_throwsMap.containsKey(methodName)) {
                Throwable t = (Throwable)AbstractStubFactory.this.m_throwsMap.get(methodName);
                t.fillInStackTrace();
                throw t;
            }
            if (AbstractStubFactory.this.m_resultMap.containsKey(methodName)) {
                return AbstractStubFactory.this.m_resultMap.get(methodName);
            }
            return this.m_delegate.invoke(proxy, method, parameters);
        }
    }

    private final class RecordingInvocationHandler
    implements InvocationHandler {
        private final InvocationHandler m_delegate;

        public RecordingInvocationHandler(InvocationHandler delegate) {
            this.m_delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
            try {
                Object result = this.m_delegate.invoke(proxy, method, parameters);
                AbstractStubFactory.this.record(new CallData(method, result, parameters));
                return result;
            }
            catch (InvocationTargetException t) {
                Throwable targetException = t.getTargetException();
                AbstractStubFactory.this.record(new CallData(method, targetException, parameters));
                throw targetException;
            }
            catch (Throwable t) {
                AbstractStubFactory.this.record(new CallData(method, t, parameters));
                throw t;
            }
        }
    }
}

