// Copyright (C) 2004 - 2009 Philip Aston
// All rights reserved.
//
// This file is part of The Grinder software distribution. Refer to
// the file LICENSE which is part of The Grinder distribution for
// licensing details. The Grinder distribution is available on the
// Internet at http://grinder.sourceforge.net/
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
// FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
// COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.

package net.grinder.testutility;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;


/**
 * <p><code>InvocationHandler</code> decorator that intercepts get
 * methods and provides stubs generated by {@link RandomStubFactory}s.
 * The same object is always returned for a given get method.</p>
 *
 * <p>Currently unused.</p>
 *
 * @author    Philip Aston
 */
public final class StubRelationshipsInvocationHandlerDecorator
  implements InvocationHandler {

  private Map<String, Object> m_stubs = new HashMap<String, Object>();
  private final InvocationHandler m_delegate;

  public StubRelationshipsInvocationHandlerDecorator(
    InvocationHandler delegate) {
    m_delegate = delegate;
  }

  public Object invoke(Object proxy, Method method, Object[] parameters)
    throws Throwable {

    final String methodName = method.getName();
    final Class<?> returnType = method.getReturnType();

    if (parameters == null || parameters.length == 0 &&
        methodName.indexOf("get") == 0 &&
        !returnType.equals(Void.TYPE)) {

      final Object existingStub = m_stubs.get(methodName);

      if (existingStub != null) {
        return existingStub;
      }

      final RandomStubFactory<? extends Object> stubFactory =
        RandomStubFactory.create(returnType);

      m_stubs.put(methodName, stubFactory.getStub());

      return stubFactory.getStub();
    }
    else {
      return m_delegate.invoke(proxy, method, parameters);
    }
  }
}
