// Copyright (C) 2005 Philip Aston
// All rights reserved.
//
// This file is part of The Grinder software distribution. Refer to
// the file LICENSE which is part of The Grinder distribution for
// licensing details. The Grinder distribution is available on the
// Internet at http://grinder.sourceforge.net/
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
// FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
// COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.

package net.grinder.testutility;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;


public final class CountingInputStream extends FilterInputStream {
  private int m_calls;
  private long m_bytes;

  public CountingInputStream(InputStream in) {
    super(in);
  }

  private int add(int i) {
    if (i > 0) {
      m_bytes += i;
    }

    ++m_calls;

    return i;
  }

  public int read() throws IOException {
    return add(super.read());
  }

  public int read(byte[] b) throws IOException {
    return add(super.read(b, 0, b.length));
  }

  public int read(byte[] b, int off, int len) throws IOException {
    return add(super.read(b, off, len));
  }

  public long getCount() {
    return m_bytes;
  }

  public int getCalls() {
    return m_calls;
  }

  public String toString() {
    return "CountingInputStream: " + m_calls + " calls, " + m_bytes + " bytes";
  }
}
