/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.ReadOnlyObjectEditor;
import net.sf.sfac.setting.Settings;
import org.apache.log4j.Logger;

public class ZipProcessor
implements FileProcessor {
    Logger log = Logger.getLogger(ZipProcessor.class);
    private ZipOutputStream zipStream;
    private InputFileInfo zipInfo;
    private StatusHolder holder = new StatusHolder(){

        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Zipping ");
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" (");
            this.appendCount(this.getByteCount(), "byte", sb);
            sb.append(")...");
            return sb.toString();
        }

        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendCount(this.getByteCount(), "byte", sb);
            sb.append(" of ");
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" zipped");
            if (this.getInputFileCount() > 1) {
                sb.append(" (");
                this.appendCount(this.getByteCount() / (long)this.getInputFileCount(), "byte", sb);
                sb.append(" per file)");
            }
            sb.append(".");
            return sb.toString();
        }
    };

    public String getProcessorName() {
        return "Zip";
    }

    public void init(Settings sett) {
    }

    public int getOutputCardinality(int inputCardinality) {
        return 1;
    }

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        int i;
        ZipOutputStream zip = this.getZipOutputStream(info, env);
        zip.putNextEntry(new ZipEntry(info.getProposedRelativePath()));
        this.holder.inputFileStarted();
        while ((i = is.read()) >= 0 && env.shouldContinue()) {
            zip.write(i);
            this.holder.bytesProcessed(1L);
        }
        zip.closeEntry();
    }

    private ZipOutputStream getZipOutputStream(InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        if (this.zipStream == null) {
            String oldExt = info.getProposedExtension();
            info.setProposedExtension("zip");
            OutputStream os = env.getOutputStream(info);
            this.zipStream = new ZipOutputStream(os);
            info.setProposedExtension(oldExt);
            this.zipInfo = info;
        } else {
            this.zipInfo.mergeInfo(info);
        }
        return this.zipStream;
    }

    public void startBatch(FileProcessorEnvironment env) throws IOException {
        this.holder.reset(ExecutionPhase.STARTING);
        this.zipStream = null;
        this.zipInfo = null;
    }

    public void endBatch(FileProcessorEnvironment env) throws IOException {
        this.zipStream.close();
        this.holder.setCurrentPhase(env.getCurrentPhase());
        this.zipStream = null;
        this.zipInfo = null;
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }

    public ObjectEditor getEditor() {
        return new ReadOnlyObjectEditor("Zip all the input files to one single output");
    }
}

